% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmWithCov.r
\name{lmWithCov}
\alias{lmWithCov}
\title{Uses covariance/correlation matrix for calculate OLS}
\usage{
lmWithCov(f, x)
}
\arguments{
\item{f}{formula for lm model}

\item{x}{correlation/covariance matrix}
}
\value{
\item{coef}{regression coefficients}
\item{r.squared}{\eqn{R^2} or coefficient of determination}
\item{formula}{formula provided as parameter}
\item{cov}{covariance/correlation matrix provided as parameter}
}
\description{
Calculate regression coefficients and \eqn{R^2} for an OLS regression.
Could be used with \code{\link{dominanceAnalysis}} to
perform a dominance analysis without the original data.
}
\examples{
cov.m<-matrix(c(1,0.2,0.3, 0.2,1,0.5,0.3,0.5,1),3,3,
dimnames=list(c("x1","x2","y"),c("x1","x2","y")))
lm.cov<-lmWithCov(y~x1+x2,cov.m)
da<-dominanceAnalysis(lm.cov)
}
