% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-functions-misc.R
\name{match_pts_to_graph}
\alias{match_pts_to_graph}
\title{match_pts_to_graph}
\usage{
match_pts_to_graph(verts, xy, connected = FALSE)
}
\arguments{
\item{verts}{A \code{data.frame} of vertices obtained from
\code{dodgr_vertices(graph)}.}

\item{xy}{coordinates of points to be matched to the vertices, either as
matrix or \pkg{sf}-formatted \code{data.frame}.}

\item{connected}{Should points be matched to the same (largest) connected
component of graph? If \code{FALSE} and these points are to be used for a
\code{dodgr} routing routine (\link{dodgr_dists}, \link{dodgr_paths}, or
\link{dodgr_flows_aggregate}), then results may not be returned if points are
not part of the same connected component. On the other hand, forcing them to
be part of the same connected component may decrease the spatial accuracy of
matching.}
}
\value{
A vector index into verts
}
\description{
Match spatial points to a spatial graph which contains vertex coordinates
}
\examples{
net <- weight_streetnet (hampi, wt_profile = "foot")
verts <- dodgr_vertices (net)
# Then generate some random points to match to graph
npts <- 10
xy <- data.frame (
                  x = min (verts$x) + runif (npts) * diff (range (verts$x)),
                  y = min (verts$y) + runif (npts) * diff (range (verts$y))
                  )
pts <- match_pts_to_graph (verts, xy)
pts # an index into verts
pts <- verts$id [pts]
pts # names of those vertices
}
\seealso{
Other misc: 
\code{\link{compare_heaps}()},
\code{\link{dodgr_flowmap}()},
\code{\link{dodgr_full_cycles}()},
\code{\link{dodgr_fundamental_cycles}()},
\code{\link{dodgr_insert_vertex}()},
\code{\link{dodgr_sample}()},
\code{\link{dodgr_sflines_to_poly}()},
\code{\link{dodgr_vertices}()},
\code{\link{match_points_to_graph}()},
\code{\link{merge_directed_graph}()},
\code{\link{summary.dodgr_dists_categorical}()},
\code{\link{write_dodgr_wt_profile}()}
}
\concept{misc}
