% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streetnet-fns.R
\name{dodgr_to_sfc}
\alias{dodgr_to_sfc}
\title{dodgr_to_sfc}
\usage{
dodgr_to_sfc(net)
}
\arguments{
\item{net}{A \pkg{dodgr} network}
}
\value{
A list containing (1) A \code{data.frame} of data associated with the
\code{sf} geometries; and (ii) A Simple Features Collection (\code{sfc}) list of
\code{LINESTRING} objects.
}
\description{
Convert a \code{dodgr} graph into a \code{list} composed of
two objects: \code{dat}, a \code{data.frame}; and
\code{geometry}, an \code{sfc} object from the (\pkg{sf}) package.
Works by aggregating edges into \code{LINESTRING}
objects representing longest sequences between all junction nodes. The
resultant objects will generally contain more \code{LINESTRING} objects than
the original \pkg{sf} object, because the former will be bisected at every
junction point.
}
\note{
The output of this function corresponds to the edges obtained from
\code{dodgr_contract_graph}. An \pkg{sf} \code{data.frame} may be created by
appending any data from the latter to the \code{sfc} output of this function -
see \pkg{sf} for details.
}
\examples{
hw <- weight_streetnet (hampi)
nrow(hw)
xy <- dodgr_to_sfc (hw)
dim (hw) # 5.845 edges
length (xy$geometry) # more linestrings aggregated from those edges
nrow (hampi) # than the 191 linestrings in original sf object
dim (xy$dat) # same number of rows as there are geometries
# sf::st_sf(xy$dat, geometry = xy$geometry, crs = 4326)
}
