% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-functions.R
\name{dodgr_convert_graph}
\alias{dodgr_convert_graph}
\title{dodgr_convert_graph}
\usage{
dodgr_convert_graph(graph, components = TRUE)
}
\arguments{
\item{graph}{A \code{data.frame} containing the edges of the graph}

\item{components}{If FALSE, components are not calculated (will generally
result in faster processing).}
}
\value{
A list of two components: (i) \code{graph}, a \code{data.frame} with
the same number of rows but with columns of \code{edge_id}, \code{from},
\code{to}, \code{d}, \code{w}, and \code{component}, not all of which may be
included; and (ii) \code{xy}, a matrix of coordinates of all vertices in
\code{graph}.
}
\description{
Convert a graph represented as an arbitarily-structured \code{data.frame} to
standard 4 or 5-column format for submission to C++ routines
}
\examples{
graph <- weight_streetnet (hampi)
names (graph)
names (dodgr_convert_graph (graph)$graph)
}
