#
# defining constants for the /documair/ package
#

#<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
documair0 <- 
#TITLE list of the /documair/ constants
#DESCRIPTION
# Just a list of constants defined with a name, a definition
# and a value. They can be modified by the user.
# Of course the modification must be consistent with the role of
# the constant, and only values should be modified.\cr
#DETAILS
# It is a named list, one component for each constant.
# A sublist is associated to each constant with two components: \samp{$d}
# for the definition and \samp{$v} for the value. Be aware that the value
# can be any object (vector, list, matrix, function,...)
#KEYWORDS tags helpful
#INPUTS
#[INPUTS]
#VALUE
# A list (it is a self-documented object).
#EXAMPLE
# names(documair0);
# print(documair0$text1);
# print(documair0$text2$v);
#REFERENCE
#SEE ALSO
#CALLING
#COMMENT
#FUTURE
#AUTHOR J.-B. Denis
#CREATED 13_10_06
#REVISED 14_05_21
#--------------------------------------------
{
  # definition of the different constants
  list(
       #
       #  <0> VERSION NUMBER
       #
       version=list(v="0.6-0",
                    d="/documair/ version number"),
       #
       #  <1> DEFINING THE DELIMITERS
       #
       com=list(v="#",
                d="First character in a line indicating a comment or the beginning of a tag"),
       ndel=list(v=c( "{", "}"),
                 d="Opening and closing braces for item names (e.g. arguments of a function)"),
       vdel=list(v=c( "<<", ">>"),
                 d="Opening and closing braces for item values (e.g. arguments of a function)"),
       tgs=list(v=list(
                  deb=list(v="#<<<<<",
                           t="Object",
                           u=1,
                           d="Identification of the object",
                           c="Inf",
                           p="rbw"),
                  tit=list(v="#TIT",
                           t="Title",
                           u=1,
                           d="Title describing the object",
                           c="Inf",
                           p="rb"),
                  des=list(v="#DES",
                           t="Description",
                           u=1,
                           d="Some lines to describe the object",
                           c="Inf",
                           p="rb"),
                  in0=list(v="#INP",
                           t="Compulsory inputs",
                           u=1,
                           d="Compulsory arguments to be given in case of a function object",
                           c="Inf",
                           p="rbl"),
                  val=list(v="#VAL",
                           t="Value",
                           u=1,
                           d="Returned object in case of a function object",
                           c="Inf",
                           p="rb"),
                  cod=list(v="#-----",
                           t="Start",
                           u=1,
                           d="Code start",
                           c="Inf",
                           p="rb"),
                  fin=list(v="#>>>>>",
                           t="End",
                           u=1,
                           d="Code end",
                           c="Inf",
                           p="rb")
                 ),
                d="self documented tags for the documentation of R objects (see $tags for more details)"),
       #
       # <3> DEFINING SOME CONSTANTS FOR THE EXAMPLES
       #
       text1=list(v=c(paste0(rep(c(1:9,0),1),collapse=""),
                      paste0(rep(c(1:9,0),2),collapse=""),
                      paste0(rep(c(1:9,0),3),collapse=""),
                      paste0(rep(c(1:9,0),4),collapse=""),
                      paste0(rep(c(1:9,0),3),collapse=""),
                      paste0(rep(c(1:9,0),2),collapse=""),
                      paste0(rep(c(1:9,0),1),collapse="")),
                  d="text example number 1"),
       text2=list(v=c("Once upon a time there was a sweet little girl.",
                      "Everyone who saw her liked her, but most of all her grandmother",
                      "Once she gave her a little cap made of red velvet.",
                      "Because it suited her so well, and she wanted to wear it all the time,",
                      "she came to be known as Little Red Riding Hood.",
                      "One day her mother said to her: ",
                      "Come Little Red Riding Hood. Here is a piece of cake and a bottle of wine.",
                      "Take them to your grandmother.",
                      "She is sick and weak, and they will do her well.",
                      "Mind your manners and give her my greetings.",
                      "Behave yourself on the way, and do not leave the path,",
                      "or you might fall down and break the glass,",
                      "and then there will be nothing for your sick grandmother."),
                  d="text example number 2"),
       text3=list(v=c("#<<<<<",
                      "paste0 <- function(...,sep='',collapse=NULL)",
                      "#TIT a better paste",
                      "#DES awaiting to change the R version",
                      "# How many time, we had to type ',sep=''?",
                      "#INP",
                      "#{\\ldots} <<To be givent to paste.>>",
                      "#{sep} <<To be given to paste.>>",
                      "#{collapse} <<To be given to paste.>>",
                      "#VAL",
                      "# A character",
                      "#-----",
                      "{",
                      "paste(...,sep=sep,collapse=collapse);",
                      "}",
                      "#>>>>>"),
                  d="text example number 3"),
       text4=list(v=c("#<<<<<",
                      "paste0 <- function(...,sep='0',collapse=NULL)",
                      "{",
                      "paste(...,sep=sep,collapse=collapse);",
                      "}",
                      "#<<<<<",
                      "paste1 <- function(...,sep='-',collapse=NULL)",
                      "{",
                      "paste(...,sep=sep,collapse=collapse);",
                      "}",
                      "#<<<<<",
                      "paste2 <- function(...,sep=':',collapse=NULL)",
                      "{",
                      "paste(...,sep=sep,collapse=collapse);",
                      "}",
                      "#>>>>>",
                      "",
                      "#<<<<<",
                      "paste4 <- function(...,sep='/',collapse=NULL)",
                      "{",
                      "paste(...,sep=sep,collapse=collapse);",
                      "}",
                      "#>>>>>"),
                  d="text example number 4"),
       tags=list(v=list(
                  deb=list(v=paste0("#","<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"),
                           t="Object",
                           u=1,
                           d="Identification of the object",
                           c="Inf",
                           p="rbw"),
                  tit=list(v=paste0("#","TITLE"),
                           t="Title",
                           u=1,
                           d="Title describing the object",
                           c="Inf",
                           p="rbc"),
                  des=list(v=paste0("#","DESCRIPTION"),
                           t="Description",
                           u=1,
                           d="Some lines to describe the object",
                           c="Inf",
                           p="rbBR"),
                  ali=list(v=paste0("#","ALIAS"),
                           t="Alias",
                           u=1,
                           d="Alias under which the object has to be documented",
                           c="1",
                           p="rbBRV"),
                  det=list(v=paste0("#","DETAILS"),
                           u=1,
                           t="Details",
                           u=1,
                           d="Additional lines to describe the object features",
                           c="Inf",
                           p="rbBR"),
                  kwd=list(v=paste0("#","KEYWORDS"),
                           t="Keywords",
                           u=1,
                           d="Keywords associated to the object",
                           c="Inf",
                           p="rbBRV"),
                  in0=list(v=paste0("#","INPUTS"),
                           t="Compulsory inputs",
                           u=1,
                           d="Compulsory arguments to be given in case of a function object",
                           c="Inf",
                           p="rb"),
                  in1=list(v=paste0("#","[INPUTS]"),
                           t="Optional inputs",
                           u=1,
                           d="Optional arguments in case of a function object",
                           c="Inf",
                           p="rbl"),
                  val=list(v=paste0("#","VALUE"),
                           t="Value",
                           u=1,
                           d="Returned object in case of a function object",
                           c="Inf",
                           p="rb"),
                  exa=list(v=paste0("#","EXAMPLE"),
                           t="Examples",
                           u=1,
                           d="Examples of using the object",
                           c="Inf",
                           p="rb"),
                  ref=list(v=paste0("#","REFERENCE"),
                           t="References",
                           u=1,
                           d="References",
                           c="Inf",
                           p="rb"),
                  sal=list(v=paste0("#","SEE ALSO"),
                           t="See",
                           u=1,
                           d="See also",
                           c="Inf",
                           p="rbBRV"),
                  cal=list(v=paste0("#","CALLING"),
                           t="Calling",
                           u=1,
                           d="Called functions",
                           c="Inf",
                           p="rb"),
                  com=list(v=paste0("#","COMMENT"),
                           t="Comments",
                           u=1,
                           d="More comments",
                           c="Inf",
                           p="rb"),
                  fut=list(v=paste0("#","FUTURE"),
                           u=1,
                           t="Evolutions",
                           u=1,
                           d="Planned evolutions",
                           c="Inf",
                           p="rb"),
                  aut=list(v=paste0("#","AUTHOR"),
                           u=1,
                           t="Author(s)",
                           u=1,
                           d="Author(s)",
                           c="Inf",
                           p="rb"),
                  cre=list(v=paste0("#","CREATED"),
                           t="Created",
                           u=1,
                           d="Creation date",
                           c="1",
                           p="rb"),
                  rev=list(v=paste0("#","REVISED"),
                           t="Revised",
                           u=1,
                           d="Revision date",
                           c="1",
                           p="rb"),
                  cod=list(v=paste0("#","--------------------------------------------"),
                           t="Start",
                           u=1,
                           d="Code start",
                           c="0",
                           p="rb"),
                  ag1=list(v="  #",
                           t="Algo(1)",
                           u=0,
                           d="Major step in the algorithm",
                           c="1",
                           p="rb"),
                  ag2=list(v="    #",
                           t="Algo(2)",
                           u=0,
                           d="Step in the algorithm",
                           c="1",
                           p="rb"),
                  ag3=list(v="      #",
                           t="Algo(3)",
                           u=0,
                           d="Algorithm component",
                           c="1",
                           p="rb"),
                  ag4=list(v="        #",
                           t="Algo(4)",
                           u=0,
                           d="Detail in the algorithm",
                           c="1",
                           p="rb"),
                  fin=list(v=paste0("#",">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"),
                           t="End",
                           u=1,
                           d="Code end",
                           c="0",
                           p="rb")
                 ),
            d=c("traditional tags for the R objects",
                "each one is equipped with five components:",
                " $v = value (character(1))",
                " $t = title (character(1))",
                " $c = content (numeric(1)): number of lines to consider,",
                "                   the first one being 1.",
                "                   0 means that no contents must be",
                "                   retains but TRUE when it exists",
                "                   else FALSE.",
                " $p = preparation (character(1)):",
                "         r remove {documair0com} at the beginning of lines",
                "         w look for the first word ('<-' or '=' as well",
                "                                    as blank are delimiters)",
                "         b remove spaces before and after each line",
                "         c concatenate all lines into a unique line ",
                "         l get the possible list which is included",
                "           and remove it from the $value, using",
                "           {documair0ndel} and {documair0vdel}.",
                " $d = description (character())")
               )
    );
}
#>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
