% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httr.R
\name{docu_embedded_sign}
\alias{docu_embedded_sign}
\alias{docu_embedded_send}
\title{Embedded docuSign}
\usage{
docu_embedded_sign(username = Sys.getenv("docuSign_username"),
  password = Sys.getenv("docuSign_password"),
  integrator_key = Sys.getenv("docuSign_integrator_key"), base_url,
  return_url, envelope_id, signer_name, signer_email, client_user_id,
  authentication_method = "None")

docu_embedded_send(username = Sys.getenv("docuSign_username"),
  password = Sys.getenv("docuSign_password"),
  integrator_key = Sys.getenv("docuSign_integrator_key"), base_url,
  return_url, uri, signer_name, signer_email, client_user_id,
  authentication_method = "None")
}
\arguments{
\item{username}{docuSign username}

\item{password}{docuSign password}

\item{integrator_key}{docusign integratorKey}

\item{base_url}{docuSign baseURL}

\item{return_url}{URL to return to after signing}

\item{envelope_id}{ID for envelope returned from \code{docu_envelope}}

\item{signer_name}{Name of person signing document}

\item{signer_email}{Email of person signing document}

\item{client_user_id}{ID for signer}

\item{authentication_method}{Method application uses to authenticate user. Defaults to "None".}

\item{uri}{uri path}
}
\description{
Get URL for embedded docuSign
}
\examples{
\dontrun{
# assuming env variables are properly set up
login <- docu_login()
env <- docu_envelope(
 account_id = login[1, "accountId"], base_url = login[1, "baseUrl"], 
 template_id = "e86ad42d-f935-4a95-8019-c9e2c902de15",
 template_roles = list(name = "Name", email = "email@example.com",
                      roleName = "Patient", clientUserId = "1"),
 email_subject = "Subject", email_blurb = "Body"
)
URL <- docu_embed(
 base_url = login[1, "baseUrl"], return_url = "www.google.com",
 signer_name = "Name", signer_email = "email@example.com", 
 client_user_id = "1", 
 envelope_id = env$envelopeId
)
}
}
