% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{txt_count_words}
\alias{txt_count_words}
\title{Count the number of spaces occurring in text}
\usage{
txt_count_words(x, pattern = "[ \\t]", ...)
}
\arguments{
\item{x}{a character vector with text}

\item{pattern}{a text pattern to count which might be contained in \code{x}. Defaults to either space or tab.}

\item{...}{other arguments, passed on to \code{\link{gregexpr}}}
}
\value{
an integer vector of the same length as \code{x} indicating how many times the pattern is occurring in \code{x}
}
\description{
The C++ doc2vec functionalities in this package assume words are either separated 
by a space or tab symbol and that each document contains less than 1000 words.\cr 
This function calculates how many words there are in each element of a character vector by counting
the number of occurrences of the space or tab symbol.
}
\examples{
x <- c("Count me in.007", "this is a set  of words",
       "more\texamples tabs-and-spaces.only", NA)
txt_count_words(x)
}
