% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_toWide.R
\name{reshape_towide}
\alias{reshape_towide}
\title{Reshape to Wide Format}
\usage{
reshape_towide(data, id, col_change, prefix, suffix, sep = "_")
}
\arguments{
\item{data}{long data}

\item{id}{column names for id, which can be one or more}

\item{col_change}{column names for exchange, which can be one or more}

\item{prefix}{column names for prefix, which can be one or more}

\item{suffix}{column names for suffix, which can be one or more}

\item{sep}{seperation}
}
\value{
A wide data.
}
\description{
Reshape to Wide Format
}
\examples{
df = data.frame(id = c(1,1,2,2,3,3,4,4),
                time = c(1,2,1,2,1,2,1,2),
                w = c(1,6,2,7,3,8,4,9))

reshape_towide(data = df,
               id = 'id',
               col_change = 'time',
               prefix = 'w')
df = data.frame(id = c(1,1,2,2,3,3,4,4),
         time = c(1,2,1,2,1,2,1,2),
         w = c(1,6,2,7,3,8,4,9),
         h = c(5,1,6,3,7,5,8,7),
         n = c(2,2,3,3,4,4,5,5))

reshape_towide(data = df,
               id = 'id',
               col_change = c('time','n'),
               prefix  = 'w',sep = '_')

reshape_towide(data = df,
               id = 'id',
               col_change = 'time',
               prefix  = c('w','h'))

reshape_towide(data = df,
               id = c('id','n'),
               col_change = 'time',
               prefix  = c('w','h'))

df = data.frame(id = c(1,1,2,2,3,3,4,4),
                time = c('a','a','a','b','b','b','c','c'),
                n=c(5,5,6,6,7,7,8,8))
reshape_towide(data = df,id = 'id',col_change = 'time')
reshape_towide(data = df,id = c('id','time'),col_change = 'n')
reshape_towide(data = df,id = 'id',col_change = c('time','n'))
}
