% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{dmbc_check_groups}
\alias{dmbc_check_groups}
\title{Auxiliary function for checking the grouping results of a fitted DMBC model.}
\usage{
dmbc_check_groups(res, est = "mean")
}
\arguments{
\item{res}{An object of class \code{dmbc_fit_list}.}

\item{est}{A length-one character vector indicating the estimate type to use.}
}
\value{
A length-one logical vector, which is equal to TRUE if all simulated chains
  provide the same cluster membership estimates, and FALSE otherwise.
}
\description{
\code{dmbc_check_groups()} is an auxiliary function for checking whether
  the cluster membership estimates provided by the individual chains of the
  fitted model provided agree or not.
}
\examples{
\dontrun{
data(simdiss, package = "dmbc")

G <- 3
p <- 2
prm.prop <- list(z = 1.5, alpha = .75)
burnin <- 2000
nsim <- 1000
seed <- 2301

set.seed(seed)

control <- list(burnin = burnin, nsim = nsim, z.prop = prm.prop[["z"]],
  alpha.prop = prm.prop[["alpha"]], random.start = TRUE, verbose = TRUE,
  nchains = 2, thin = 10, store.burnin = TRUE, threads = 2,
  parallel = "snow")
sim.dmbc <- dmbc(simdiss, p, G, control)

dmbc_check_groups(sim.dmbc)
}

}
\references{
Venturini, S., Piccarreta, R. (2019), "A Bayesian Approach for Model-Based
  Clustering of Several Binary Dissimilarity Matrices: the \pkg{dmbc}
  Package in \code{R}", Technical report.
}
\seealso{
\code{\link{dmbc_get_configuration}()} for a description of the
  configuration extractor function.

\code{\link{dmbc_fit_list}} for a description of a fitted
  DMBC model.
}
\author{
Sergio Venturini \email{sergio.venturini@unito.it}
}
