% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixarfilms.R
\name{dm_pixarfilms}
\alias{dm_pixarfilms}
\title{Creates a dm object for the \pkg{pixarfilms} data}
\usage{
dm_pixarfilms(..., color = TRUE, consistent = FALSE)
}
\arguments{
\item{...}{These dots are for future extensions and must be empty.}

\item{color}{Boolean, if \code{TRUE} (default), the resulting \code{dm} object will
have colors assigned to different tables for visualization with
\code{dm_draw()}.}

\item{consistent}{Boolean, In the original \code{dm}  the  \code{film} column in
\code{pixar_films} contains missing values so cannot be made a proper primary key.
Set to \code{TRUE} to remove those records.}
}
\value{
A \code{dm} object consisting of \pkg{pixarfilms} tables, complete with
primary and foreign keys and optionally colored.
}
\description{
Creates an example \code{\link{dm}} object from the tables in
\pkg{pixarfilms}, along with the references.
}
\examples{
\dontshow{if (rlang::is_installed(c("pixarfilms", "DiagrammeR"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_pixarfilms()
dm_pixarfilms() \%>\%
  dm_draw()
\dontshow{\}) # examplesIf}
}
