% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.R
\name{dplyr_table_manipulation}
\alias{dplyr_table_manipulation}
\alias{filter.zoomed_dm}
\alias{mutate.zoomed_dm}
\alias{transmute.zoomed_dm}
\alias{select.zoomed_dm}
\alias{rename.zoomed_dm}
\alias{distinct.zoomed_dm}
\alias{arrange.zoomed_dm}
\alias{slice.zoomed_dm}
\alias{group_by.zoomed_dm}
\alias{ungroup.zoomed_dm}
\alias{summarise.zoomed_dm}
\title{\pkg{dplyr} table manipulation methods for zoomed dm objects}
\usage{
\method{filter}{zoomed_dm}(.data, ...)

\method{mutate}{zoomed_dm}(.data, ...)

\method{transmute}{zoomed_dm}(.data, ...)

\method{select}{zoomed_dm}(.data, ...)

\method{rename}{zoomed_dm}(.data, ...)

\method{distinct}{zoomed_dm}(.data, ..., .keep_all = FALSE)

\method{arrange}{zoomed_dm}(.data, ...)

\method{slice}{zoomed_dm}(.data, ..., .keep_pk = NULL)

\method{group_by}{zoomed_dm}(.data, ...)

\method{ungroup}{zoomed_dm}(x, ...)

\method{summarise}{zoomed_dm}(.data, ...)
}
\arguments{
\item{.data}{object of class \code{zoomed_dm}}

\item{...}{see corresponding function in package \pkg{dplyr} or \pkg{tidyr}}

\item{.keep_all}{For \code{distinct.zoomed_dm()}: see \code{\link[dplyr:distinct]{dplyr::distinct}}}

\item{.keep_pk}{For \code{slice.zoomed_dm}: Logical, if \code{TRUE}, the primary key will be retained during this transformation. If \code{FALSE}, it will be dropped.
By default, the value is \code{NULL}, which causes the function to issue a message in case a primary key is available for the zoomed table.
This argument is specific for the \code{slice.zoomed_dm()} method.}

\item{x}{For \code{ungroup.zoomed_dm}: object of class \code{zoomed_dm}}
}
\description{
Use these methods without the '.zoomed_dm' suffix (see examples).
}
\examples{
zoomed <- dm_nycflights13() \%>\%
  dm_zoom_to(flights) \%>\%
  group_by(month) \%>\%
  arrange(desc(day)) \%>\%
  summarize(avg_air_time = mean(air_time, na.rm = TRUE))
zoomed
dm_insert_zoomed(zoomed, new_tbl_name = "avg_air_time_per_month")
}
