% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_line.R
\name{number_line}
\alias{number_line}
\alias{as.number_line}
\alias{is.number_line}
\alias{left_point}
\alias{left_point<-}
\alias{right_point}
\alias{right_point<-}
\alias{start_point}
\alias{start_point<-}
\alias{end_point}
\alias{end_point<-}
\alias{number_line_width}
\alias{reverse_number_line}
\alias{shift_number_line}
\alias{expand_number_line}
\alias{invert_number_line}
\alias{compress_number_line}
\alias{number_line_sequence}
\title{Number line objects}
\usage{
number_line(l, r, id = NULL, gid = NULL)

as.number_line(x)

is.number_line(x)

left_point(x)

left_point(x) <- value

right_point(x)

right_point(x) <- value

start_point(x)

start_point(x) <- value

end_point(x)

end_point(x) <- value

number_line_width(x)

reverse_number_line(x, direction = "both")

shift_number_line(x, by = 1)

expand_number_line(x, by = 1, point = "both")

invert_number_line(x, point = "both")

compress_number_line(
  x,
  methods = "overlap",
  collapse = FALSE,
  deduplicate = TRUE,
  method = "overlap"
)

number_line_sequence(x, by = 1, length.out = NULL)
}
\arguments{
\item{l}{Left point of the \code{number_line} object. Must be able to be coerced to a \code{numeric} object}

\item{r}{Right point of the \code{number_line} object. Must be able to be coerced to a \code{numeric} object}

\item{id}{Unique \code{numeric} element identifier. Optional}

\item{gid}{Unique \code{numeric} group identifier. Optional}

\item{x}{\code{number_line} object}

\item{value}{\code{numeric} based value}

\item{direction}{Type of \code{"number_line"} objects to be reversed.
Options are; \code{"increasing"}, \code{"decreasing"} or \code{"both"} (default).}

\item{by}{increment or decrement. Passed to \code{seq()} in \code{number_line_sequence()}}

\item{point}{\code{"start"} or \code{"end"} point}

\item{methods}{Methods of overlap. Check different pairs of \code{number_line} objects with the different \code{methods}}

\item{collapse}{If \code{TRUE}, collapse the compressed results yet again.}

\item{deduplicate}{if \code{TRUE}, retains only one \code{number_line} object per set of overlapping \code{number_line}.}

\item{method}{Method of overlap. Check every pair of \code{number_line} objects with the same \code{method}. Deprecated. Please use \code{methods} instead.}

\item{length.out}{desired length of the sequence. Passed to \code{seq()}}
}
\value{
\code{number_line} object
}
\description{
\code{number_line} - A range of \code{numeric} values on a number line.
}
\details{
A \code{number_line} object represents a range of real numbers on a number line.

Visually, it's presented as the \code{left (l)} and \code{right (r) points} of the range. This may differ from \code{start} and \code{end points}.
The \code{start point} is the lowest value in the range, regardless of whether it's at the \code{left} or \code{right point}.

The location of the \code{start} point - \code{left} or \code{right}, indicates whether it's an \code{"increasing"} or \code{"decreasing"} range.
This is the \code{direction} of the \code{number_line}.

\bold{\code{reverse_number_line()}} - reverses the direction of a \code{number_line} object.
A reversed \code{number_line} object has its \code{l} and \code{r} points swapped.
The \code{direction} argument specifies which type of \code{number_line} objects will be reversed.
\code{number_line} objects with non-finite \code{starts} or \code{end points} i.e. (\code{NA}, \code{NaN} and \code{Inf}) can't be reversed.

\bold{\code{shift_number_line()}} - Shift a \code{number_line} object towards the positive or negative end of the number line.

\bold{\code{expand_number_line()}} - Increase or decrease the width or length of a \code{number_line} object.

\bold{\code{invert_number_line()}} - Invert the \code{left} and/or \code{right} points from a negative to positive value or vice versa.

\bold{\code{compress_number_line()}} - \code{"compress"} or \code{"collapse"} overlapping \code{number_line} objects into a new \code{number_line} object that covers the \code{start} and \code{end} points of the originals.
This results in duplicate \code{number_line} objects with the \code{start} and \code{end} points of the new expanded \code{number_line} object.
See \code{\link{overlaps}} for further details on overlapping \code{number_line} objects.
If a familiar (but unique) \code{id} is used when creating the \code{number_line} objects,
\bold{\code{compress_number_line}} can be an alternative for simple implementations of \code{\link{links}} or \code{\link{episodes}}.

\bold{\code{number_line_sequence()}} - Convert a \code{number_line} object into a sequence of finite numbers.
The direction of the sequence will correspond to that of the \code{number_line} object.
}
\examples{
date <- function(x) as.Date(x, "\%d/\%m/\%Y")
dttm <- function(x) as.POSIXct(x, "UTC",format="\%d/\%m/\%Y \%H:\%M:\%S")

number_line(-100, 100); number_line(10, 11.2)

# Other numeric based object classes are also compatible
number_line(dttm("15/05/2019 13:15:07"), dttm("15/05/2019 15:17:10"))

# However, a warning is given if 'l' and 'r' have different classes.
# Consider if this needs to be corrected.
number_line(2, date("05/01/2019"))

# Convert numeric based objects to `number_line` objects
as.number_line(5.1); as.number_line(date("21/10/2019"))

# A test for number_line objects
a <- number_line(0, -100)
b <- number_line(date("25/04/2019"), date("01/01/2019"))
is.number_line(a); is.number_line(b)

# Structure of a number_line object
left_point(a); right_point(a); start_point(a); end_point(a)

# Reverse number_line objects
reverse_number_line(number_line(date("25/04/2019"), date("01/01/2019")))
reverse_number_line(number_line(200, -100), "increasing")
reverse_number_line(number_line(200, -100), "decreasing")

# Shift number_line objects
c <- number_line(5, 6)
# Towards the positive end of the number line
shift_number_line(x = c(c, c), by = c(2, 3))
# Towards the negative end of the number line
shift_number_line(x = c(c, c), by = c(-2, -3))

# Change the width or length of a number_line object
d <- c(number_line(3, 6), number_line(6, 3))

expand_number_line(d, 2)
expand_number_line(d, -2)
expand_number_line(d, c(2,-1))
expand_number_line(d, 2, "start")
expand_number_line(d, 2, "end")

# Invert `number_line` objects
e <- c(number_line(3, 6), number_line(-3, -6), number_line(-3, 6))

e
invert_number_line(e)
invert_number_line(e, "start")
invert_number_line(e, "end")

# Collapse number line objects
x <- c(number_line(10,10), number_line(10,20), number_line(5,30),  number_line(30,40))
compress_number_line(x, deduplicate = FALSE)
compress_number_line(x)
compress_number_line(x, collapse=TRUE)
compress_number_line(x, collapse=TRUE, methods = "inbetween")

# Convert a number line object to its series of real numbers
number_line_sequence(number_line(1, 5))
number_line_sequence(number_line(5, 1), .5)
number_line_sequence(number_line(5:1, 1:5), 1:5)

nl <- number_line(dttm("01/04/2019 00:00:00"), dttm("04/04/2019 00:00:00"))

number_line_sequence(c(nl, nl), c(episode_unit[["days"]] * 1.5, episode_unit[["hours"]] * 12))

}
\seealso{
\code{\link{overlaps}}, \code{\link{set_operations}}, \code{\link{episodes}} and \code{\link{links}}
}
