% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_richness.R
\name{div_richness}
\alias{div_richness}
\alias{div_richness.numeric}
\alias{div_richness.species_distribution}
\title{Number of Species of a Community}
\usage{
div_richness(x, ...)

\method{div_richness}{numeric}(
  x,
  estimator = c("jackknife", "iChao1", "Chao1", "rarefy", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  level = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{div_richness}{species_distribution}(
  x,
  estimator = c("jackknife", "iChao1", "Chao1", "rarefy", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  level = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  gamma = FALSE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a numeric vector containing abundances or probabilities,
or an object of class \link{abundances}  or \link{probabilities}.}

\item{...}{Unused.
The metacommunity if built by combining the community abundances with respect to their weight.}

\item{estimator}{An estimator of richness to evaluate the total number of species.}

\item{jack_alpha}{The risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{The highest jackknife order allowed. Default is 10.}

\item{level}{The level of interpolation or extrapolation.
It may be a sample size (an integer) or a sample coverage
(a number between 0 and 1).
The asymptotic \code{estimator} is used in extrapolation
(i.e. a \code{level} greater than the sample size).}

\item{probability_estimator}{A string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only by the estimator of richness "rarefy".}

\item{unveiling}{A string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only by the estimator of richness "rarefy".}

\item{coverage_estimator}{An estimator of sample coverage used by \link{coverage}.}

\item{as_numeric}{If \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{gamma}{If \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}
}
\value{
A tibble with the site names, the estimators used and the estimated numbers of species.
}
\description{
Estimate the number of species from abundance or probability data.
Several estimators are available to deal with incomplete sampling.
}
\details{
Bias correction requires the number of individuals.
Chao's correction techniques are from \insertCite{Chao2014;textual}{divent}
and \insertCite{Chiu2014a;textual}{divent}.
The Jackknife estimator is calculated by a straight adaptation of the code
by Ji-Ping Wang (jackknife in package \strong{SPECIES}).
The optimal order is selected according to
\insertCite{Burnham1978,Burnham1979;textual}{divent}.
Many other estimators are available elsewhere, the ones implemented here are
necessary for other entropy estimations.

Richness can be estimated at a specified \code{level} of interpolation or
extrapolation, either a chosen sample size or sample coverage
\insertCite{Chiu2014a}{divent}, rather than its asymptotic value.
Extrapolation relies on the estimation of the asymptotic richness.
If \code{probability_estimator} is "naive", then the asymptotic estimation of
richness is made using the chosen \code{estimator}, else the asymptotic
distribution of the community is derived and its estimated richness adjusted
so that the richness of a sample of this distribution of the size of the
actual sample has the richness of the actual sample.
}
\examples{
# Diversity of each community
div_richness(paracou_6_abd)
# gamma diversity
div_richness(paracou_6_abd, gamma = TRUE)

# At 80\% coverage
div_richness(paracou_6_abd, level = 0.8)

}
\references{
\insertAllCited{}
}
