% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HurdleNegativeBinomial.R
\name{HurdleNegativeBinomial}
\alias{HurdleNegativeBinomial}
\title{Create a hurdle negative binomial distribution}
\usage{
HurdleNegativeBinomial(mu, theta, pi)
}
\arguments{
\item{mu}{Location parameter of the negative binomial component of the distribution.
Can be any positive number.}

\item{theta}{Overdispersion parameter of the negative binomial component of the distribution.
Can be any positive number.}

\item{pi}{Zero-hurdle probability, can be any value in \verb{[0, 1]}.}
}
\value{
A \code{HurdleNegativeBinomial} object.
}
\description{
Hurdle negative binomial distributions are frequently used to model counts
with overdispersion and many zero observations.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail.

In the following, let \eqn{X} be a hurdle negative binomial random variable with parameters
\code{mu} = \eqn{\mu} and \code{theta} = \eqn{\theta}.

\strong{Support}: \eqn{\{0, 1, 2, 3, ...\}}{{0, 1, 2, 3, ...}}

\strong{Mean}:
\deqn{
    \mu \cdot \frac{\pi}{1 - F(0; \mu, \theta)}
  }{
    \mu \cdot \pi/(1 - F(0; \mu, \theta))
  }

where \eqn{F(k; \mu)} is the c.d.f. of the \code{\link{NegativeBinomial}} distribution.

\strong{Variance}:
\deqn{
    m \cdot \left(1 + \frac{\mu}{\theta} + \mu - m \right)
  }{
    m \cdot (1 + \mu/\theta + \mu - m)
  }

where \eqn{m} is the mean above.

\strong{Probability mass function (p.m.f.)}: \eqn{P(X = 0) = 1 - \pi} and for \eqn{k > 0}

\deqn{
    P(X = k) = \pi \cdot \frac{f(k; \mu, \theta)}{1 - F(0; \mu, \theta)}
  }{
    P(X = k) = \pi \cdot f(k; \mu, \theta)/(1 - F(0; \mu, \theta))
  }

where \eqn{f(k; \mu, \theta)} is the p.m.f. of the \code{\link{NegativeBinomial}}
distribution.

\strong{Cumulative distribution function (c.d.f.)}: \eqn{P(X \le 0) = 1 - \pi} and for \eqn{k > 0}

\deqn{
    P(X \le k) = 1 - \pi + \pi \cdot \frac{F(k; \mu, \theta) - F(0; \mu, \theta)}{1 - F(0; \mu, \theta)}
  }{
    P(X \le k) = 1 - \pi + \pi \cdot (F(k; \mu, \theta) - F(0; \mu, \theta))/(1 - F(0; \mu, \theta))
  }

\strong{Moment generating function (m.g.f.)}:

Omitted for now.
}
\examples{
## set up a hurdle negative binomial distribution
X <- HurdleNegativeBinomial(mu = 2.5, theta = 1, pi = 0.75)
X

## standard functions
pdf(X, 0:8)
cdf(X, 0:8)
quantile(X, seq(0, 1, by = 0.25))

## cdf() and quantile() are inverses for each other
quantile(X, cdf(X, 3))

## density visualization
plot(0:8, pdf(X, 0:8), type = "h", lwd = 2)

## corresponding sample with histogram of empirical frequencies
set.seed(0)
x <- random(X, 500)
hist(x, breaks = -1:max(x) + 0.5)
}
\seealso{
Other discrete distributions: 
\code{\link{Bernoulli}()},
\code{\link{Binomial}()},
\code{\link{Categorical}()},
\code{\link{Geometric}()},
\code{\link{HurdlePoisson}()},
\code{\link{HyperGeometric}()},
\code{\link{Multinomial}()},
\code{\link{NegativeBinomial}()},
\code{\link{Poisson}()},
\code{\link{PoissonBinomial}()},
\code{\link{ZINegativeBinomial}()},
\code{\link{ZIPoisson}()},
\code{\link{ZTNegativeBinomial}()},
\code{\link{ZTPoisson}()}
}
\concept{discrete distributions}
