% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{data}
\name{stat_auc}
\alias{stat_auc}
\alias{StatAuc}
\alias{geom_auc}
\alias{GeomAuc}
\title{Fill out area under the curve for a plotted PDF}
\usage{
stat_auc(
  mapping = NULL,
  data = NULL,
  geom = "auc",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  from = -Inf,
  to = Inf,
  annotate = FALSE,
  digits = 3,
  ...
)

geom_auc(
  mapping = NULL,
  data = NULL,
  stat = "auc",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  from = -Inf,
  to = Inf,
  annotate = FALSE,
  digits = 3,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{from}{Left end-point of interval}

\item{to}{Right end-point of interval}

\item{annotate}{Should P() be added in the upper left corner as an annotation?
Works also with a colour character, e.g., "red".}

\item{digits}{Number of digits shown in annotation}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}
}
\description{
Fill out area under the curve for a plotted PDF
}
\examples{

N1 <- Normal()
plot_pdf(N1) + geom_auc(to = -0.645)
plot_pdf(N1) + geom_auc(from = -0.645, to = 0.1, annotate = TRUE)

N2 <- Normal(0, c(1, 2))
plot_pdf(N2) + geom_auc(to = 0)
plot_pdf(N2) + geom_auc(from = -2, to = 2, annotate = TRUE)
}
\keyword{datasets}
