% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Poisson.R
\name{Poisson}
\alias{Poisson}
\title{Create a Poisson distribution}
\usage{
Poisson(lambda)
}
\arguments{
\item{lambda}{The shape parameter, which is also the mean and the
variance of the distribution. Can be any positive number.}
}
\value{
A \code{Poisson} object.
}
\description{
Poisson distributions are frequently used to model counts.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail.

In the following, let \eqn{X} be a Poisson random variable with parameter
\code{lambda} = \eqn{\lambda}.

\strong{Support}: \eqn{\{0, 1, 2, 3, ...\}}{{0, 1, 2, 3, ...}}

\strong{Mean}: \eqn{\lambda}

\strong{Variance}: \eqn{\lambda}

\strong{Probability mass function (p.m.f)}:

\deqn{
    P(X = k) = \frac{\lambda^k e^{-\lambda}}{k!}
  }{
    P(X = k) = \lambda^k e^(-\lambda) / k!
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    P(X \le k) = e^{-\lambda}
    \sum_{i = 0}^{\lfloor k \rfloor} \frac{\lambda^i}{i!}
  }{
    P(X \le k) = e^(-\lambda)
    \sum_{i = 0}^k \lambda^i / i!
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = e^{\lambda (e^t - 1)}
  }{
    E(e^(tX)) = e^(\lambda (e^t - 1))
  }
}
\examples{

set.seed(27)

X <- Poisson(2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
\seealso{
Other discrete distributions: 
\code{\link{Bernoulli}()},
\code{\link{Binomial}()},
\code{\link{Categorical}()},
\code{\link{Geometric}()},
\code{\link{HurdlePoisson}()},
\code{\link{HyperGeometric}()},
\code{\link{Multinomial}()},
\code{\link{NegativeBinomial}()},
\code{\link{ZIPoisson}()}
}
\concept{discrete distributions}
