% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tukey.R
\name{quantile.Tukey}
\alias{quantile.Tukey}
\title{Determine quantiles of a Tukey distribution}
\usage{
\method{quantile}{Tukey}(x, probs, ...)
}
\arguments{
\item{x}{A vector of elements whose cumulative probabilities you would
like to determine given the distribution \code{d}.}

\item{probs}{A vector of probabilities.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{probs}.
}
\description{
Determine quantiles of a Tukey distribution
}
\examples{

set.seed(27)

X <- Tukey(4L, 16L, 2L)
X

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other Tukey distribution: 
\code{\link{cdf.Tukey}()}
}
\concept{Tukey distribution}
