% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{log_likelihood}
\alias{log_likelihood}
\title{Compute the log-likelihood of a probability distribution given data}
\usage{
log_likelihood(d, x, ...)
}
\arguments{
\item{d}{A probability distribution object such as those created by
a call to \code{\link[=Bernoulli]{Bernoulli()}}, \code{\link[=Beta]{Beta()}}, or \code{\link[=Binomial]{Binomial()}}.}

\item{x}{A vector of data to compute the likelihood.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
the log-likelihood
}
\description{
Compute the log-likelihood of a probability distribution given data
}
\examples{

X <- Normal()

log_likelihood(X, c(-1, 0, 0, 0, 3))
}
