% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{autoplot.distribution}
\alias{autoplot.distribution}
\title{Plot a distribution}
\usage{
\method{autoplot}{distribution}(
  x,
  type = c("pdf", "cdf"),
  n = 100,
  quantile_range = c(0.001, 0.999),
  ...
)
}
\arguments{
\item{x}{The distribution(s) to plot.}

\item{type}{The type of plot to make (must be either \code{"pdf"} or \code{"cdf"}).}

\item{n}{The resolution (number of points) used to display the distribution.}

\item{quantile_range}{The range of the distribution (specified as quantiles).}

\item{...}{Unused.}
}
\description{
\lifecycle{deprecated}
}
\details{
Visualise distribution(s) by plotting its probability density function
(\code{\link[=density]{density()}}) or cumulative distribution function (\code{\link[=cdf]{cdf()}}).
Note: This function currently only works for continuous distributions.
}
\examples{
library(ggplot2)
dist <- c(dist_normal(mu = 0, sigma = 1), dist_student_t(df = 3))
autoplot(dist, type = "pdf")
autoplot(dist, type = "cdf")

}
