% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preds.R
\name{preds}
\alias{preds}
\title{Predict distributional parameters of a bamlss family with a bamlss model}
\usage{
preds(model, newdata)
}
\arguments{
\item{model}{A fitted bamlss model object, created with \code{\link{bamlss}}.}

\item{newdata}{A data.frame with explanatory variables as columns,
and rows with the combinations you want to do predictions for. Furthermore,
whether or not to include the intercept has to be specified via a logical
variable \code{intercept}.}
}
\value{
A data.frame with one column for every distributional parameter
  and a row for every covariate combination that should be predicted.
}
\description{
This function takes a fitted model and a dataframe with explanatory
variables and a column for the intercept to compute predicted parameters
for the specified distribution.
}
\examples{
# Generating data
data_fam <- model_fam_data(fam_name = "BE")
# Fit model
library("gamlss")
beta_model <- gamlss(BE ~ norm2 + binomial1,
  data = data_fam, family = BE())
# Get 3 predictions
pred_df <- data_fam[sample(1:nrow(data_fam), 3), c("binomial1", "norm2")]
param_preds <- preds(beta_model, pred_df)
}
