% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testParameterSetList}
\alias{testParameterSetList}
\alias{checkParameterSetList}
\alias{assertParameterSetList}
\title{assert/check/test/ParameterSetList}
\usage{
testParameterSetList(
  object,
  errormsg = "One or more items in the list are not ParameterSets"
)

checkParameterSetList(
  object,
  errormsg = "One or more items in the list are not ParameterSets"
)

assertParameterSetList(
  object,
  errormsg = "One or more items in the list are not ParameterSets"
)
}
\arguments{
\item{object}{object to test}

\item{errormsg}{custom error message to return if assert/check fails}
}
\value{
If check passes then \code{assert} returns invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is a list of \link{ParameterSet}s.
}
\examples{
testParameterSetList(list(Binomial$new(), 5)) # FALSE
testParameterSetList(list(Binomial$new(), Exponential$new())) # TRUE
}
