% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testUnivariate}
\alias{testUnivariate}
\alias{checkUnivariate}
\alias{assertUnivariate}
\title{assert/check/test/Univariate}
\usage{
testUnivariate(
  object,
  errormsg = paste(object$short_name, "is not univariate")
)

checkUnivariate(
  object,
  errormsg = paste(object$short_name, "is not univariate")
)

assertUnivariate(
  object,
  errormsg = paste(object$short_name, "is not univariate")
)
}
\arguments{
\item{object}{Distribution}

\item{errormsg}{custom error message to return if assert/check fails}
}
\value{
If check passes then \code{assert} returns invisibly and \code{test}/\code{check}
  return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
  an error message as string, \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if Distribution is univariate.
}
\examples{
testUnivariate(Binomial$new()) # TRUE

}
