% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distr6.R
\docType{package}
\name{distr6-package}
\alias{distr6}
\alias{distr6-package}
\title{distr6: Object Oriented Distributions in R}
\description{
distr6 is an object oriented (OO) interface, primarily used for interacting with probability
distributions in R. Additionally distr6 includes functionality for composite distributions,
a symbolic representation for mathematical sets and intervals, basic methods for common kernels
and numeric methods for distribution analysis. distr6 is the official R6 upgrade to the distr
family of packages.
}
\details{
The main features of distr6 are:

\itemize{
\item Currently implements 36 probability distributions (and 11 Kernels) including all distributions in the R
stats package. Each distribution has (where possible) closed form analytic expressions for
basic statistical methods.
\item Decorators that add further functionality to probability distributions including numeric
results for useful modelling functions such as p-norms and k-moments.
\item Wrappers for composite distributions including convolutions, truncation, mixture
distributions and product distributions.
}

To learn more about distr6, start with the distr6 vignette:

\code{vignette("distr6", "distr6")}

And for more advanced usage see the complete tutorials at

\href{https://alan-turing-institute.github.io/distr6/index.html}{https://alan-turing-institute.github.io/distr6/index.html}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://alan-turing-institute.github.io/distr6/}
  \item \url{https://github.com/alan-turing-institute/distr6/}
  \item Report bugs at \url{https://github.com/alan-turing-institute/distr6/issues}
}

}
\author{
\strong{Maintainer}: Raphael Sonabend \email{raphael.sonabend.15@ucl.ac.uk} (\href{https://orcid.org/0000-0001-9225-4654}{ORCID})

Authors:
\itemize{
  \item Franz Kiraly \email{f.kiraly@ucl.ac.uk}
}

Other contributors:
\itemize{
  \item Peter Ruckdeschel \email{peter.ruckdeschel@uni-oldenburg.de} (Author of distr) [contributor]
  \item Matthias Kohl \email{Matthias.Kohl@stamats.de} (Author of distr) [contributor]
  \item Shen Chen \email{seanchen9832@icloud.com} [contributor]
  \item Jordan Deenichin \email{d.deenichin@gmail.com} [contributor]
  \item Chengyang Gao \email{garoc371@gmail.com} [contributor]
  \item Chloe Zhaoyuan Gu \email{guzhaoyuan@outlook.com} [contributor]
  \item Yunjie He \email{zcakebx@ucl.ac.uk} [contributor]
  \item Xiaowen Huang \email{hxw3678@gmail.com} [contributor]
  \item Shuhan Liu \email{Shuhan.liu.99@gmail.com} [contributor]
  \item Runlong Yu \email{edwinyurl@hotmail.com} [contributor]
  \item Chijing Zeng \email{britneyzenguk@gmail.com} [contributor]
  \item Qian Zhou \email{zcakqz1@ucl.ac.uk} [contributor]
}

}
