% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_species.R
\name{check_species}
\alias{check_species}
\title{Check for available distribution data}
\usage{
check_species(x, level = "species")
}
\arguments{
\item{x}{A \code{data.frame} with one column containing the species names
in the format 'genus_epithet'.}

\item{level}{A character string describing wether the check should be conducted
on the "species" or "genus" level.}
}
\value{
Returns a data frame containing the matching taxon number and species
names of x in the FloraWeb database. Mismatches are saved in the attributes of
the data frame. The output can be modified and used in \code{\link{get.dist}}
with \code{input = TRUE}.
}
\description{
This function will compare the species or genera in your species list with the
entries of the FLORKART-database and returns the matching entries.
}
\details{
If input data consists only of genus names the function will call
\code{level = "genus"}.
}
\examples{
\dontrun{
library("distdrawr")
specieslist <- data.frame(c("Bellis_perennis","Taraxacum_officinale",
                            "Capsella_bursa-pastoris"))
check_species(specieslist, level="species")
}
}
\references{
Datenbank FLORKART der Floristischen Kartierung Deutschlands,
Stand 2013, Bundesamt fuer Naturschutz (BfN) und Netzwerk Phytodiversitaet
Deutschland (NetPhyD): \url{http://www.floraweb.de}
}

