% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/svdstuff.R
\docType{class}
\name{SVDMaster}
\alias{SVDMaster}
\title{Create a master object to control worker objects generated by \code{\link{SVDWorker}}}
\format{An \code{\link{R6Class}} generator object}
\usage{
SVDMaster
}
\description{
\code{SVDMaster} objects instantiate and run a distributed SVD computation
}
\section{Methods}{


\describe{
  \item{\code{SVDMaster$new(defnId, k, debug=FALSE)}}{Create an SVD master object
        with the specified id, the number of singular vectors desired, and the debugging flag.
        The debug flag is used for debugging computations}
  \item{\code{kosher()}}{Check if inputs and state of object are sane. For future use}
  \item{\code{updateV(arg)}}{Return an updated value for the V vector}
  \item{\code{updateU(arg)}}{Return an updated value for the U vector}
  \item{\code{fixFit(v, d)}}{Construct the residual matrix using given the v vector and d so far}
  \item{\code{reset()}}{Initialize the computation}
  \item{\code{dimX(, ...)}}{Return the dimensions of the matrix}
  \item{\code{normU(arg, ...)}}{Normalize U vector by \code{arg}}
  \item{\code{addSite(name, url)}}{Add a worker site
        for participating in the distributed computation}
  \item{\code{run(k = private$k, thr = 1e-8, max.iter = 100)}}{Run the SVD computation until either the
        threshold is reached or the max.iter number of iterations are used up}
  \item{\code{summary()}}{Return the summary of results}
}
}
\seealso{
\code{SVDWorker} which goes hand-in-hand with this object
}
\keyword{datasets}

