% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_time_keywords_translate.R
\name{utils_time_keywords_translate}
\alias{utils_time_keywords_translate}
\title{Translates The User's Time Keywords Into Valid Ones}
\usage{
utils_time_keywords_translate(keyword = NULL)
}
\arguments{
\item{keyword}{(optional, character string) A time keyword such as "day". Default: NULL}
}
\value{
Time keyword.
}
\description{
Internal function to translate misnamed or abbreviated keywords into valid ones. Uses \code{\link[=utils_time_keywords_dictionary]{utils_time_keywords_dictionary()}} as reference dictionary.
}
\examples{
#millennia
utils_time_keywords_translate(
  keyword = "1000 years"
)

utils_time_keywords_translate(
  keyword = "1000 y"
)

utils_time_keywords_translate(
  keyword = "thousands"
)

#years
utils_time_keywords_translate(
  keyword = "year"
)

utils_time_keywords_translate(
  keyword = "y"
)

#days
utils_time_keywords_translate(
  keyword = "d"
)

utils_time_keywords_translate(
  keyword = "day"
)

#seconds
utils_time_keywords_translate(
  keyword = "s"
)

utils_time_keywords_translate(
  keyword = "sec"
)
}
\seealso{
Other internal_time_handling: 
\code{\link{utils_as_time}()},
\code{\link{utils_coerce_time_class}()},
\code{\link{utils_is_time}()},
\code{\link{utils_new_time}()},
\code{\link{utils_time_keywords}()},
\code{\link{utils_time_keywords_dictionary}()},
\code{\link{utils_time_units}()}
}
\concept{internal_time_handling}
