% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo_names.R
\name{zoo_name_clean}
\alias{zoo_name_clean}
\title{Clean Name of a Zoo Time Series}
\usage{
zoo_name_clean(
  x = NULL,
  lowercase = FALSE,
  separator = "_",
  capitalize_first = FALSE,
  capitalize_all = FALSE,
  length = NULL,
  suffix = NULL,
  prefix = NULL
)
}
\arguments{
\item{x}{(required, zoo object) Zoo time series to analyze. Default: NULL.}

\item{lowercase}{(optional, logical) If TRUE, all names are coerced to lowercase. Default: FALSE}

\item{separator}{(optional, character string) Separator when replacing spaces and dots. Also used to separate \code{suffix} and \code{prefix} from the main word. Default: "_".}

\item{capitalize_first}{(optional, logical) Indicates whether to capitalize the first letter of each name Default: FALSE.}

\item{capitalize_all}{(optional, logical) Indicates whether to capitalize all letters of each name Default: FALSE.}

\item{length}{(optional, integer) Minimum length of abbreviated names. Names are abbreviated via \code{\link[=abbreviate]{abbreviate()}}. Default: NULL.}

\item{suffix}{(optional, character string) Suffix for the clean names. Default: NULL.}

\item{prefix}{(optional, character string)  Prefix for the clean names. Default: NULL.}
}
\value{
zoo time series
}
\description{
Combines \code{\link[=utils_clean_names]{utils_clean_names()}} and \code{\link[=zoo_name_set]{zoo_name_set()}} to help clean, abbreviate, capitalize, and add a suffix or a prefix to the name of a zoo object.
}
\examples{
#simulate zoo time series
x <- zoo_simulate()

#get current name
zoo_name_get(x = x)

#change name
x <- zoo_name_set(
  x = x,
  name = "My.New.name"
)

zoo_name_get(x = x)

#clean name
x <- zoo_name_clean(
  x = x,
  lowercase = TRUE
)

zoo_name_get(x = x)
}
\seealso{
Other zoo_functions: 
\code{\link{zoo_aggregate}()},
\code{\link{zoo_name_get}()},
\code{\link{zoo_name_set}()},
\code{\link{zoo_permute}()},
\code{\link{zoo_plot}()},
\code{\link{zoo_resample}()},
\code{\link{zoo_smooth_exponential}()},
\code{\link{zoo_smooth_window}()},
\code{\link{zoo_time}()},
\code{\link{zoo_to_tsl}()},
\code{\link{zoo_vector_to_matrix}()}
}
\concept{zoo_functions}
