% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disco.R
\name{disco.score}
\alias{disco.score}
\title{Calculate concordance score for differentially expressed genes in two data sets}
\usage{
disco.score(x)
}
\arguments{
\item{x}{object of class matchedOrtholog}
}
\value{
A numerical vector of the disco scores
}
\description{
For each pair of matched (orthologous) genes from an object of class mtchedOrtholog calculates the concordance / discordance score.
The rationale is to formulate a metric allowing to compare heterologous
data sets, e.g. data sets from different sources, technical platforms or
even organisms.
}
\details{
\deqn{\textrm{disco.score} := |logFC_1|\cdot|logFC_2|\cdot(|log_{10}(p_1)| + |log_{10}(p_2)|) \cdot \textrm{sign}(logFC_1) \cdot \textrm{sign}(logFC_2)}

Where
\describe{
   \item{\eqn{logFC_1}}{log fold change of the expression change of the gene from the first data set}
   \item{\eqn{logFC_2}}{log fold change of the expression change of the gene from the second data set}
   \item{\eqn{p1}}{differential regulation p-value for the gene from the first data set}
   \item{\eqn{p2}}{differential regulation p-value for the gene from the second data set}
}
}
\examples{
data(orthologs)
orthologs$disco.score <- disco.score(orthologs)
}
