% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{groups}
\alias{groups}
\alias{group_members}
\alias{group_create}
\alias{group_delete}
\title{Work with groups}
\usage{
groups(url = NULL, key = NULL, user = NULL, ...)

group_members(name, url = NULL, key = NULL, user = NULL, ...)

group_create(name, url = NULL, key = NULL, user = NULL, ...)

group_delete(id, url = NULL, key = NULL, user = NULL, ...)
}
\arguments{
\item{url}{Base url for a Discourse installation. See 
\code{\link{disc_setup}}}

\item{key}{Your api key on the Discourse installation. See 
\code{\link{disc_setup}}}

\item{user}{Your user name on the Discourse installation. See 
\code{\link{disc_setup}}}

\item{...}{Named parameters passed on to \code{\link[crul]{HttpClient}}}

\item{name}{(character) A group name. required}

\item{id}{(numeric) A group id. required}
}
\description{
Work with groups
}
\examples{
\dontrun{
# all groups
groups()

# specific group by name
group_members("admins")
group_members("moderators")
group_members("trust_level_3")

# create a group
(res <- group_create("group_testing2"))

# delete a group
group_delete(res$basic_group$id)
}
}
