% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rutabaga.R
\name{ste_mean}
\alias{ste_mean}
\alias{ste_mean.default}
\title{Standard error of mean}
\usage{
ste_mean(x, na.rm = FALSE, na_as_zero = na.rm, ...)

\method{ste_mean}{default}(x, na.rm = FALSE, na_as_zero = na.rm, ...)
}
\arguments{
\item{x}{R object}

\item{na.rm}{whether to remove \code{NA}; default is false}

\item{na_as_zero}{whether convert \code{NA} to zero}

\item{...}{passed to other methods}
}
\value{
A numerical number that is the standard error of the mean
}
\description{
Ported from \code{'rutabaga'} package, calculates standard error
of mean. The sample size is determined by number of none-\code{NA} numbers
by default
}
\examples{

x <- rnorm(100)

ste_mean(x)

# internal implementation
identical(ste_mean(x), sd(x) / sqrt(100))

}
\seealso{
\code{\link{mean_se}}
}
