% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-flex-div.R
\name{html_class}
\alias{html_class}
\alias{combine_html_class}
\alias{remove_html_class}
\title{Combine, add, or remove 'HTML' classes}
\usage{
combine_html_class(...)

remove_html_class(target, class)
}
\arguments{
\item{...}{one or more characters, classes to combine; duplicated classes
will be removed}

\item{target}{characters, class list}

\item{class}{one or more characters, classes to be removed from \code{target}}
}
\value{
A character string of new 'HTML' class
}
\description{
Combine 'HTML' classes to produce nice, clean 'HTML' class
string via \code{combine_html_class}, or to remove a class via
\code{remove_html_class}
}
\examples{

# Combine classes "a b c d e"
combine_html_class("a", "b  a", c("c", " d", "b"), list("e ", "a"))

# Remove class
remove_html_class("a b   c  e", c("b", "c "))

}
