% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format_yq}
\alias{format_yq}
\title{Coerce and Format to Year-Quarter Strings}
\usage{
format_yq(x, q = NULL, format = "\%Y-Q\%q")
}
\arguments{
\item{x, q}{Two integer (vectors). \code{q} is optional and the interpretation of
\code{x} will depend on whether \code{q} is supplied or not:
\itemize{
\item if only \code{x} is supplied, \code{x} will be passed to \code{\link[=as_date_yq]{as_date_yq()}}
(e.g. \code{x = 20161} means first quarter of 2016)
\item if \code{x} and \code{q} are supplied, \code{x} is interpreted as year and \code{q} as
quarter.
}}

\item{format}{A format that uses a subset of the same placeholders as
\code{\link[base:strptime]{base::strptime()}}:
\tabular{rl}{
\code{\%Y} \tab Year with century (the full year)\cr
\code{\%y} \tab Year without century (the last two digits of the year)\cr
\code{\%m} \tab Month as a decimal numbers (01-12)\cr
\code{\%B} \tab Full month name\cr
\code{\%b} \tab Abbreviated month name
}
Not all placeholders are supported for all \code{date_xx} subclasses.
Literal \% can be escaped with \code{"\%\%"} (as in \code{\link[base:sprintf]{base::sprintf()}}).}
}
\value{
a \code{character} vector
}
\description{
Coerce and Format to Year-Quarter Strings
}
\section{Formatting shorthands}{


Format shorthand functions in the form of \code{format_y*_[preset]()} directly
apply formatting presets to anything  that can be coerced to a \code{date_xx}.
This is notably handy as they can be used as a labelling function for
\strong{ggplot2}  axes (see \code{vignette("dint")})
}

\examples{

format_yq(2015, 1)
format_yq(20151, format = "short")
format_yq(20151, format = "shorter")

}
\seealso{
\code{\link[=format.date_yq]{format.date_yq()}}

Other coerce and format functions: \code{\link{format_ym}},
  \code{\link{format_yw}}
}
\concept{coerce and format functions}
