% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ca.R
\docType{methods}
\name{ca}
\alias{ca}
\alias{ca-method}
\alias{ca,data.frame-method}
\alias{ca,matrix-method}
\title{Correspondence Analysis}
\usage{
ca(object, ...)

\S4method{ca}{data.frame}(object, rank = NULL, sup_row = NULL, sup_col = NULL)

\S4method{ca}{matrix}(object, rank = NULL, sup_row = NULL, sup_col = NULL)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} numeric \code{\link{matrix}} or a
\code{\link{data.frame}}.}

\item{...}{Currently not used.}

\item{rank}{An \code{\link{integer}} value specifying the maximal number of
components to be kept in the results. If \code{NULL} (the default),
\eqn{min(m, p) - 1} components will be returned.}

\item{sup_row}{A \code{\link{numeric}} or \code{\link{logical}} vector specifying the indices of
the supplementary rows.}

\item{sup_col}{A \code{\link{numeric}} or \code{\link{logical}} vector specifying the indices of
the supplementary columns.}
}
\value{
A \code{\linkS4class{CA}} object.
}
\description{
Computes a simple correspondence analysis based on the singular value
decomposition.
}
\examples{
## Load data
data("zuni", package = "folio")

## The chi square of independence between the two variables
stats::chisq.test(zuni)

## Compute correspondence analysis
X <- ca(zuni)

## Get row coordinates
get_coordinates(X, margin = 1)

## Get column coordinates
get_coordinates(X, margin = 2)

## Get row distances to centroid
get_distances(X, margin = 1)

## Get row inertias
get_inertia(X, margin = 1)

## Get row contributions
get_contributions(X, margin = 1)

## Get eigenvalues
get_eigenvalues(X)
}
\references{
Greenacre, Michael J. \emph{Theory and Applications of Correspondence
Analysis}. London: Academic Press, 1984.

Lebart, L., Piron, M. and Morineau, A. \emph{Statistique exploratoire
multidimensionnelle: visualisation et inférence en fouille de données}.
Paris: Dunod, 2006.
}
\seealso{
\code{\link[=mutator]{get_*()}}, \code{\link[stats:predict]{stats::predict()}}, \code{\link[=svd]{svd()}}

Other multivariate analysis: 
\code{\link{bootstrap}()},
\code{\link{pca}()},
\code{\link{predict}()}
}
\author{
N. Frerebeau
}
\concept{multivariate analysis}
