% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnnModel.R
\name{deconvDDLSObj}
\alias{deconvDDLSObj}
\title{Deconvolute bulk gene expression samples (bulk RNA-Seq)}
\usage{
deconvDDLSObj(
  object,
  name.data = "Bulk.DT",
  normalize = TRUE,
  scaling = "standardize",
  simplify.set = NULL,
  simplify.majority = NULL,
  use.generator = FALSE,
  batch.size = 64,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{\linkS4class{DigitalDLSorter}} object with
\code{trained.data} and \code{deconv.data} slots.}

\item{name.data}{Name of the data stored in the \code{DigitalDLSorter}
object. If not provided, the first data set will be used.}

\item{normalize}{Normalize data before deconvolution (\code{TRUE} by
default).}

\item{scaling}{How to scale data before training. It may be:
\code{"standardize"} (values are centered around the mean with a unit
standard deviation) or \code{"rescale"} (values are shifted and rescaled so
that they end up ranging between 0 and 1). If \code{normalize = FALSE},
data is not scaled.}

\item{simplify.set}{List specifying which cell types should be compressed
into a new label whose name will be the list item. See examples for
details. If provided, results are stored in a list with 'raw' and
'simpli.set' results.}

\item{simplify.majority}{List specifying which cell types should be
compressed into the cell type with the highest proportion in each sample.
Unlike \code{simplify.set}, it allows to maintain the complexity of the
results while compressing the information, as no new labels are created. If
provided, the results are stored in a list with 'raw' and 'simpli.majority'
results.}

\item{use.generator}{Boolean indicating whether to use generators for
prediction (\code{FALSE} by default).}

\item{batch.size}{Number of samples per batch. Only when \code{use.generator
= TRUE}.}

\item{verbose}{Show informative messages during the execution.}
}
\value{
\code{\linkS4class{DigitalDLSorter}} object with
\code{deconv.results} slot. The resulting information is a data frame with
samples (\eqn{i}) as rows and cell types (\eqn{j}) as columns. Each entry
represents the proportion of \eqn{j} cell type in \eqn{i} sample. If
\code{simplify.set} or/and \code{simpplify.majority} are provided, the
\code{deconv.results} slot will contain a list with raw and simplified
results.
}
\description{
Deconvolute bulk gene expression samples (bulk RNA-Seq). This function
requires a \code{DigitalDLSorter} object with a trained Deep Neural Network
model (\code{\link{trained.model}} slot) and the new bulk RNA-Seq samples to
be deconvoluted in the \code{deconv.data} slot. See
\code{?\link{loadDeconvData}} for more details.
}
\details{
This function is intended for users who have built a devonvolution model
using their own single-cell RNA-Seq data. If you want to use a pre-trained
model to deconvolute your samples, see \code{?\link{deconvDigitalDLSorter}}.
}
\examples{
\dontrun{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(30, lambda = 5), nrow = 15, ncol = 20,
      dimnames = list(paste0("Gene", seq(15)), paste0("RHC", seq(20)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(20)),
    Cell_Type = sample(x = paste0("CellType", seq(6)), size = 20,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(15))
  )
)
DDLS <- createDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE, 
  sc.log.FC = FALSE
)
probMatrixValid <- data.frame(
  Cell_Type = paste0("CellType", seq(6)),
  from = c(1, 1, 1, 15, 15, 30),
  to = c(15, 15, 30, 50, 50, 70)
)
DDLS <- generateBulkCellMatrix(
  object = DDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  prob.design = probMatrixValid,
  num.bulk.samples = 50,
  verbose = TRUE
)
# training of DDLS model
tensorflow::tf$compat$v1$disable_eager_execution()
DDLS <- trainDDLSModel(
  object = DDLS,
  on.the.fly = TRUE,
  batch.size = 15,
  num.epochs = 5
)
# simulating bulk RNA-Seq data
countsBulk <- matrix(
  stats::rpois(100, lambda = sample(seq(4, 10), size = 100, replace = TRUE)),
  nrow = 40, ncol = 15,
  dimnames = list(paste0("Gene", seq(40)), paste0("Bulk", seq(15)))
)
seBulk <- SummarizedExperiment(assay = list(counts = countsBulk))
DDLS <- loadDeconvData(
  object = DDLS,
  data = seBulk,
  name.data = "Example"
)
# simplify arguments
simplify <- list(CellGroup1 = c("CellType1", "CellType2", "CellType4"),
                 CellGroup2 = c("CellType3", "CellType5"))
DDLS <- deconvDDLSObj(
  object = DDLS,
  name.data = "Example",
  simplify.set = simplify,
  simplify.majority = simplify
)
}
}
\references{
Torroja, C. and Sánchez-Cabo, F. (2019). digitalDLSorter: A Deep
Learning algorithm to quantify immune cell populations based on scRNA-Seq
data. Frontiers in Genetics 10, 978. doi: \doi{10.3389/fgene.2019.00978}
}
\seealso{
\code{\link{trainDDLSModel}}
\code{\linkS4class{DigitalDLSorter}}
}
