% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_distance_matrix.R
\name{get_distance_matrix}
\alias{get_distance_matrix}
\alias{getDistanceMatrix}
\alias{get_DDM}
\title{Diffusion Distance Matrix}
\usage{
get_distance_matrix(
  g,
  tau,
  type = "Normalized Laplacian",
  weights = NULL,
  as_dist = FALSE,
  verbose = TRUE
)

getDistanceMatrix(g, tau, type = "Normalized Laplacian", weights = NULL,
                         verbose = TRUE)

get_DDM(
  g,
  tau,
  type = "Normalized Laplacian",
  weights = NULL,
  as_dist = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{g}{a (single-layer) network}

\item{tau}{diffusion time}

\item{type}{default "Normalized Laplacian". The type of Laplacian (i.e. of
dynamics) to consider. Other types available are:
\describe{
  \item{Laplacian}{for the classical combinatorial Laplacian matrix;
    it governs the diffusion dynamics on the network}
  \item{Normalized Laplacian}{for the Laplacian matrix normalized by degree
    matrix, the so-called classical random walk normalized Laplacian;
    it governs stochastic walks on the network}
  \item{Quantum Laplacian}{for the Laplacian matrix normalized to be
    symmetric; it governs quantum walks on the network}
  \item{MERW normalized Laplacian}{the maximal-entropy random walk (RW)
    normalized Laplacian; it governs stochastic walks on the network,
    in which the random walker moves according to a maximal-entropy RW [1].}
}
Note that you can type abbreviations, e.g. "L", "N", "Q", "M" for the
respective types (case is ignored). The argument match is done through
\code{\link[strex]{match_arg}}.}

\item{weights}{edge weights, representing the strength/intensity (not the cost!)
of each link. If weights is NULL (the default) and g has an edge attribute
called weight, then it will be used automatically.
If this is NA then no weights are used (even if the graph has a weight attribute).}

\item{as_dist}{If the function should return a matrix or an object of class "dist" as
returned from [stats::as.dist]. Default is FALSE if the number of nodes is smaller
than 1000.}

\item{verbose}{default TRUE}
}
\value{
The diffusion distance matrix \eqn{D_t}, a square numeric matrix
  of the \eqn{L^2}-norm distances between posterior probability vectors, i.e.
  Euclidean distances between the rows of the stochastic matrix
  \eqn{P(t) = e^{-\tau L}}, where \eqn{-L = -(I - T)} is the generator of the
  continuous-time random walk (Markov chain) of given \code{type} over network
  \code{g}.
}
\description{
Returns a matrix where each entry encodes the diffusion distance
between two nodes of a network.

The diffusion distance at time \eqn{\tau} between nodes \eqn{i, j \in G}
is defined as
\deqn{D_{\tau}(i, j) = \vert \mathbf{p}(t|i) - \mathbf{p}(t|j) \vert_2}
with \eqn{\mathbf{p}(t|i) = (e^{- \tau L})_{i\cdot} = \mathbf{e}_i e^{- \tau L}}
indicating the i-th row of the stochastic matrix \eqn{e^{- \tau L}} and
representing the probability (row) vector of a random walk dynamics
corresponding to the initial condition \eqn{\mathbf{e}_i}, i.e. the random
walker is in node \eqn{i} at time \eqn{\tau = 0} with probability 1.
}
\section{Functions}{
\itemize{
\item \code{getDistanceMatrix}: Old deprecated function
}}

\examples{
g <- igraph::sample_pa(10, directed = FALSE)
dm_crw <- get_distance_matrix(g, tau = 1)
dm_merw <- get_distance_matrix(g, tau = 1, type = "MERW")
}
\references{
De Domenico, M. (2017). Diffusion Geometry Unravels the Emergence of
  Functional Clusters in Collective Phenomena. Physical Review Letters.
  \doi{10.1103/PhysRevLett.118.168301}

  Bertagnolli, G., & De Domenico, M. (2021). Diffusion geometry of multiplex and
  interdependent systems. Physical Review E, 103(4), 042301.
  \doi{10.1103/PhysRevE.103.042301}
  \href{https://arxiv.org/abs/2006.13032}{arXiv: 2006.13032}
}
\seealso{
\code{\link{get_diffusion_probability_matrix}}
}
\keyword{diffusion}
\keyword{distance}
