% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genNLR.R
\name{genNLR}
\alias{genNLR}
\title{Generates data set based on generalized logistic regression DIF and DDF models.}
\usage{
genNLR(N = 1000, ratio = 1, itemtype = "dich", a, b, c, d, mu = 0, sigma = 1)
}
\arguments{
\item{N}{numeric: number of rows representing respondents. (default is 1000).}

\item{ratio}{numeric: ratio of respondents number in reference and focal group.}

\item{itemtype}{character: type of items to be generated. Options are \code{"dich"} (default) for
dichotomous item based on non-linear regression model for DIF detection (see \code{\link[difNLR]{difNLR}}
for details), \code{"nominal"} for nominal items based on multinomial model for DDF detection (see
\code{\link[difNLR]{ddfMLR}} for detail), and \code{"ordinal"} for ordinal data based on adjacent
category logit model (for details see \code{\link[difNLR]{difORD}}).}

\item{a}{numeric: matrix representing discriminations with m rows
(where m is number of items). Need to be provided. See \strong{Details}.}

\item{b}{numeric: numeric: matrix representing difficulties with m rows
(where m is number of items). Need to be provided. See \strong{Details}.}

\item{c}{numeric: matrix representing guessings (lower asymptotes) with m rows
(where m is number of items). Default is \code{NULL}. See \strong{Details}.}

\item{d}{numeric: matrix representing inattentions (upper asymptotes) with m rows
(where m is number of items). Default is \code{NULL}. See \strong{Details}.}

\item{mu}{numeric: a mean vector of the underlying distribution. The first value corresponds to
reference group, the second to focal group. Default is 0 value for both groups.}

\item{sigma}{numeric: a standard deviation vector of the underlying distribution. The first value
corresponds to reference group, the second to focal group. Default is 1 value for both groups.}
}
\value{
A \code{data.frame} containing \code{N} rows representing respondents and \code{m + 1} columns representing
\code{m} items. The last column is group membership variable with coding \code{"0"} for reference group and
\code{"1"} for focal group.
}
\description{
Generates dichotomous, nominal, and ordinal data based on generalized logistic regression
models for DIF and DDF detection.
}
\details{
The \code{a}, \code{b}, \code{c} and \code{d} are numeric matrices with m rows (where m is number of items)
representing parameters of regression models for DIF and DDF detection.

For option \code{itemtype = "dich"}, matrices should have two columns. The first column represents
parameters of the reference group and the second of the focal group. In case that only one column is
provided, parameters are set to be the same for both groups.

For options \code{itemtype = "nominal"} and \code{itemtype = "ordinal"}, matrices \code{c} and \code{d}
are ignored. Matrices \code{a} and \code{b} contain parameters for distractors. For example, when
item with 4 different choices is supposed to be generated, user provide matrices with 6 columns.
First 3 columns correspond to distractors parameters for reference group and last three columns
for focal group. The number of choices can differ for items. Matrices \code{a} and \code{b}
need to consist of as many columns as is the maximum number of distractors. Items with less
choices can containt NAs.
}
\examples{
# seed
set.seed(123)
# generating parameters for dichotomous data with DIF, 5 items
a <- matrix(runif(10, 0.8, 2), ncol = 2)
b <- matrix(runif(10, -2, 2), ncol = 2)
c <- matrix(runif(10, 0, 0.25), ncol = 2)
d <- matrix(runif(10, 0.8, 1), ncol = 2)
# generating dichotomous data set with 300 observations (150 each group)
genNLR(N = 300, a = a, b = b, c = c, d = d)
# generating dichotomous data set with 300 observations (150 each group)
# and different mean and standard deviation for underlying distribution
genNLR(N = 300, a = a, b = b, c = c, d = d, mu = c(1, 0), sigma = c(1, 2))
# generating dichotomous data set with 300 observations (250 reference group, 50 focal)
genNLR(N = 300, ratio = 5, a = a, b = b, c = c, d = d)

# generating parameters for nominal data with DDF, 5 items,
# each item 3 choices
a <- matrix(runif(20, 0.8, 2), ncol = 4)
b <- matrix(runif(20, -2, 2), ncol = 4)
# generating nominal data set with 300 observations (150 each group)
genNLR(N = 300, itemtype = "nominal", a = a, b = b)
# generating nominal data set with 300 observations (250 reference group, 50 focal)
genNLR(N = 300, itemtype = "nominal", ratio = 5, a = a, b = b)

# generating parameters for nominal data with DDF, 5 items,
# items 1 and 2 have 2 choices, items 3, 4 and 5 have 3 choices
a <- matrix(runif(20, 0.8, 2), ncol = 4)
a[1:2, c(2, 4)] <- NA
b <- matrix(runif(20, -2, 2), ncol = 4)
b[1:2, c(2, 4)] <- NA
# generating nominal data set with 300 observations (150 each group)
genNLR(N = 300, itemtype = "nominal", a = a, b = b)
# generating nominal data set with 300 observations (250 reference group, 50 focal)
genNLR(N = 300, itemtype = "nominal", ratio = 5, a = a, b = b)
}
\references{
Drabinova, A. & Martinkova, P. (2017). Detection of differential item functioning with nonlinear regression:
A non-IRT approach accounting for guessing. Journal of Educational Measurement, 54(4), 498--517,
\doi{10.1111/jedm.12158}.
}
\seealso{
\code{\link[difNLR]{difNLR}}, \code{\link[difNLR]{difORD}}, \code{\link[difNLR]{ddfMLR}}
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
