% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct.R
\name{dct}
\alias{dct}
\title{Construct a Dictionary}
\usage{
dct(..., x = list(...), types = NULL)
}
\arguments{
\item{...}{(\code{ANY}) \cr
Named arguments with names corresponding to the items to add to the
dictionary, where the keys are the names and the values are the
elements. Names must be unique.}

\item{x}{(\code{list()}) \cr
A named list with the names corresponding to the items to add to the
dictionary, where the keys are the list names and the values are the
list elements. Names must be unique.}

\item{types}{(\code{character()}) \cr
If non-NULL then \code{types} creates a typed dictionary in which all
elements of the dictionary must inherit from these \code{types}. Any class
can be given to \code{types} as long as there is a valid \code{as.character}
method associated with the class.}
}
\description{
Sugar function wrapping \verb{[Dictionary]$new}.
}
\examples{
# untyped
dct(a = 1, b = 2, c = "a")

# typed - class is forced
dct(a = 1L, b = 2L, c = 3L, types = "integer")

# list constructor
dct(x = list(a = 1, b = 2, c = "a"))

# with R6
d <- dct(a = 1)
dct(d = d)
}
