% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_engine_ranger.R
\docType{data}
\name{regularization_factor}
\alias{regularization_factor}
\alias{regularize_depth}
\alias{significance_threshold}
\alias{lower_quantile}
\alias{splitting_rule}
\alias{ranger_class_rules}
\alias{ranger_reg_rules}
\alias{ranger_split_rules}
\alias{num_random_splits}
\title{Parameters for possible engine parameters for ranger}
\format{
An object of class \code{character} of length 4.

An object of class \code{character} of length 3.

An object of class \code{character} of length 7.
}
\usage{
regularization_factor(range = c(0, 1), trans = NULL)

regularize_depth(values = c(TRUE, FALSE))

significance_threshold(range = c(-10, 0), trans = log10_trans())

lower_quantile(range = c(0, 1), trans = NULL)

splitting_rule(values = ranger_split_rules)

ranger_class_rules

ranger_reg_rules

ranger_split_rules

num_random_splits(range = c(1L, 15L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}

\item{values}{For \code{splitting_rule()}, a character string of possible values.
See \code{ranger_split_rules}, \code{ranger_class_rules}, and \code{ranger_reg_rules} for
appropriate values. For \code{regularize_depth()}, either \code{TRUE} or \code{FALSE}.}
}
\description{
These parameters are auxiliary to random forest models that use the "ranger"
engine. They correspond to tuning parameters that would be specified using
\code{set_engine("ranger", ...)}.
}
\details{
To use these, check \code{?ranger::ranger} to see how they are used. Some are
conditional on others. For example, \code{significance_threshold()},
\code{num_random_splits()}, and others are only used when
\code{splitting_rule = "extratrees"}.
}
\examples{
regularization_factor()
regularize_depth()
}
\keyword{datasets}
