## ----setup, include = FALSE----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ------------------------------------------------------------------------
library(dhh)

## ------------------------------------------------------------------------
dhh(0.5)
dhh(0.5, 0, 1, 0.1)

## ------------------------------------------------------------------------
dhh(c(0.5, 0.7))

## ---- fig.show='hold'----------------------------------------------------
curve(dhh(x, a=0, b=1, alpha=0.1), -1, 2)
curve(dhh(x, a=0, b=10, alpha=0.1), -1, 11)

## ------------------------------------------------------------------------
phh(0.5)
phh(0.5, 0, 1, 0.1)

## ------------------------------------------------------------------------
phh(c(0.5, 0.7))

## ---- fig.show='hold'----------------------------------------------------
curve(phh(x, a=0, b=1, alpha=0.1), -1, 2)
curve(phh(x, a=0, b=10, alpha=0.1), -1, 11)

## ------------------------------------------------------------------------
qhh(0.9)
qhh(0.9, a=0, b=1, alpha=0.1)

## ------------------------------------------------------------------------
phh(qhh((1:9)/10))

## ---- fig.show='hold'----------------------------------------------------
curve(qhh(x, 0, 1, 0.1), from = 0.1, to = 0.9)
curve(qhh(x, a=10, b=100, alpha = 0.1), from = 0.1, to = 0.9)

## ------------------------------------------------------------------------
rhh(5)
rhh(5, a = 0, b = 1, alpha = 0.1)

## ------------------------------------------------------------------------
hist(rhh(10000), freq=FALSE)
curve(dhh, add = TRUE, col = 2)

## ------------------------------------------------------------------------
dhh(c(0.1, 0.01, 0.001, 0.0001, 0.00001))

