% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwrapper.R
\name{dgQ2DI_to_Q2DI}
\alias{dgQ2DI_to_Q2DI}
\title{Convert from Q2DI to Q2DI}
\usage{
dgQ2DI_to_Q2DI(dggs, in_quad, in_i, in_j)
}
\arguments{
\item{dggs}{A dggs object from dgconstruct()}

\item{in_quad}{Vector of quad numbers}

\item{in_i}{Vector of quadrant i values}

\item{in_j}{Vector of quadrant j values}
}
\value{
Returns a dggs object which can be passed to other dggridR
            functions
}
\description{
Uses a discrete global grid system to convert between Q2DI
            and Q2DI (see vignette for details)
}
\examples{
\dontrun{
library(dggridR)
dggs <- dgconstruct(res=20)

dgQ2DI_to_Q2DI(dggs, in_quad, in_i, in_j)
}

}
