% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.predict.dfrr.R
\name{plot.predict.dfrr}
\alias{plot.predict.dfrr}
\title{Plot  dfrr predictions}
\usage{
\method{plot}{predict.dfrr}(
  x,
  id = NULL,
  main = id,
  col = "blue",
  lwd = 2,
  lty = "solid",
  cex.circle = 1,
  col.circle = "black",
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{a \code{predict.dfrr}-object}

\item{id}{a vector of length one or more containing subject ids to plot. Must be matched with
\code{rownames(newdata)}. Defaults to
 all subject ids.}

\item{main}{a vector of length one or \code{length(id)} containing the title of plots.}

\item{col, lwd, lty, ...}{graphical parameters passed to \code{\link{plot}}}

\item{cex.circle, col.circle}{size and color of circles and filled circles.}

\item{ylim}{a vector of length two indicating the range of y-axis of the plot.}
}
\value{
This function generates the plot of predictions.
}
\description{
Plot a  \code{predict.dfrr} object.
}
\details{
The output is the plot of predictions of latent functions given the new covariates.
For the case in which \code{newydata} is also given, the predictions are plotted
 over the observed binary sequence.
The binary sequence is illustrated with circles and filled circles for the values
of zero and one, respectively.
}
\examples{
set.seed(2000)
\donttest{N<-50;M<-24}
\dontshow{N<-30;M<-12}
X<-rnorm(N,mean=0)
time<-seq(0,1,length.out=M)
Y<-simulate_simple_dfrr(beta0=function(t){cos(pi*t+pi)},
                        beta1=function(t){2*t},
                        X=X,time=time)

 #The argument T_E indicates the number of EM algorithm.
#T_E is set to 1 for the demonstration purpose only.
#Remove this argument for the purpose of converging the EM algorithm.
dfrr_fit<-dfrr(Y~X,yind=time,T_E=1)

newdata<-data.frame(X=c(1,0))
  preds<-predict(dfrr_fit,newdata=newdata)
  plot(preds)

newdata<-data.frame(X=c(1,0))
newydata<-data.frame(.obs=rep(1,5),.index=c(0.0,0.1,0.2,0.3,0.7),.value=c(1,1,1,0,0))
preds<-predict(dfrr_fit,newdata=newdata,newydata = newydata)
plot(preds)

}
\references{
Choi, H., & Reimherr, M.  A geometric approach to confidence regions and bands for functional parameters .
 \emph{Journal of the Royal Statistical Society, Series B Statistical methodology} 2018; 80:239-260.
}
