\name{mta_sim}
\alias{mta_sim}
\alias{print.mta_sim}
\title{MTA design Simulator}
\description{
\code{mta_sim} is used to generate simulation replicates of Phase I clinical trial for Molecularly Targeted Agent using the design proposed by Riviere et al. entitled "Phase I/II Dose-Finding Design for Molecularly Targeted Agent: Plateau Determination using Adaptive Randomization".
}
\usage{
mta_sim(ngroups=1, ndose, p_tox, p_eff, tox_max, eff_min, prior_tox, prior_eff, 
poisson_rate=1, n, cohort_start=3, cohort=3, tite=TRUE, time_full, 
method="MTA-RA", s_1=function(n_cur){0.2}, s_2=0.07, cycle, nsim, c_tox=0.90, 
c_eff=0.40, seed=1907)
}
\arguments{
  \item{ngroups}{Number of groups for the dose-finding process leading to the recommendation of different dose levels. Several groups of efficacy (e.g. based on biomarker) sharing the same toxicity can be considered. The default value is set at 1.}
  \item{ndose}{Number of dose levels.}
  \item{p_tox}{A vector of the true toxicity probabilities associated with the doses.}
  \item{p_eff}{A vector (or matrix if several groups) of the true efficacy probabilities associated with the doses.}
  \item{tox_max}{Toxicity upper bound, i.e. maximum acceptable toxicity probability.}
  \item{eff_min}{Efficacy lower bound, i.e. minimum acceptable efficacy probability.}
  \item{prior_tox}{A vector of initial guesses of toxicity probabilities associated with the doses. Must be of same length as \code{p_tox}.}
  \item{prior_eff}{A vector (or matrix if several groups) of initial guesses of efficacy probabilities associated with the doses. Must be of same length as \code{p_eff}.}
  \item{poisson_rate}{(A Vector, if seleveral groups, of the) Rate(s) for the Poisson process used to simulate patient arrival (for each group), i.e. expected number of arrivals per observation window. The default value is set at 1.}
  \item{n}{Total number of patients (per groups if several) to include in the dose-finding trial.}
  \item{cohort_start}{Cohort size for the start-up phase. The default value is set at 3.}
  \item{cohort}{Cohort size for the model phase. The default value is set at 3.}
  \item{tite}{A boolean indicating if the efficacy is considered as a time-to-event (default value TRUE), or if it is a binary outcome (FALSE).}
  \item{time_full}{Full follow-up time window. This argument is used only if tite=TRUE.}
  \item{method}{A character string to specify the method for dose allocation (<=> plateau determination). The default method "MTA-RA" use adaptive randomization on posterior probabilities for the plateau location. Method based on difference in efficacy probabilities is specified by "MTA-PM".}
  \item{s_1}{A function depending on the number of patients included used for adaptive randomization in plateau determination, only used if the estimation method chosen is "MTA-RA". The default function is function(n_cur){0.2}.}
  \item{s_2}{Cutoff for plateau determination, only used if the estimation method chosen is "MTA-PM". Can be seen as the minimal efficacy difference of practical importance. The default value is 0.07.}
  \item{cycle}{Minimum waiting time between two dose cohorts (usually a toxicity cycle). This argument is used only if tite=TRUE.}
  \item{nsim}{Number of simulations.}
  \item{c_tox}{Tocixity threshold for decision rules. The default value is set at 0.90.}
  \item{c_eff}{Efficacy threshold for decision rules. The default value is set at 0.40.}
  \item{seed}{Seed of the random number generator. Default value is set at 1907.}
}
\value{
An object of class "mta_sim" is returned, consisting of the operating characteristics of the design specified. Objects generated by \code{mta_sim} contain at least the following components: 
\item{p_tox}{True toxicities.}
\item{p_eff}{True efficacies (for each group).}
\item{prior_tox}{Prior toxicities.}
\item{prior_eff}{Prior efficacies (for each group).}
\item{rec_dose}{Percentage of Selection (for each group).}
\item{n_pat_dose}{Number of patients at each dose (for each group).}
\item{n_tox}{Number of toxicities at each dose (for each group).}
\item{n_eff}{Number of efficacies at each dose (for each group).}
\item{inconc}{Percentage of inclusive trials (for each group).}
\item{method}{Allocation method.}
\item{nsim}{Number of simulations.}
\item{n_pat_tot}{Total patients accrued.}
\item{tox_max}{Toxicity upper bound.}
\item{eff_min}{Efficacy lower bound.}
\item{poisson_rate}{Rate for Poisson process.}
\item{c_tox}{Toxicity threshold.}
\item{c_eff}{Efficacy threshold.}
\item{cohort_start}{Cohort size start-up phase.}
\item{cohort}{Cohort size model phase.}
\item{tite}{Type of outcome for efficacy (time-to-event or binary).}
\item{time_full}{If efficacy is a time-to-event, full follow-up time is also reminded.}
\item{cycle}{If efficacy is a time-to-event, minimum waiting time between two dose cohorts (cycle) is also reminded.}
\item{duration}{If efficacy is a time-to-event, trial mean duration is also returned.}
}
\references{
Riviere, M-K., Yuan, Y., Jourdan, J-H., Dubois, F., and Zohar, S. (2014). Phase I/II Dose-Finding Design for Molecularly Targeted Agent: Plateau Determination using Adaptive Randomization. Statistics in medicine.
}
\note{The "MTA-PM" method is not implemented for non-binary efficacy, as "MTA-RA" is recommended for general use.}
\author{Jacques-Henri Jourdan and Marie-Karelle Riviere-Jourdan \email{marie-karelle.riviere@inserm.fr}}
\seealso{
  \code{\link{mta_next}}.
}
\examples{
p_tox_sc1 = c(0.005, 0.01, 0.02, 0.05, 0.10, 0.15)
p_eff_sc1_g1 = c(0.01, 0.10, 0.30, 0.50, 0.80, 0.80)
p_tox_sc2 = c(0.01, 0.05, 0.10, 0.25, 0.50, 0.70)
p_eff_sc2_g2 = matrix(c(0.40, 0.01, 0.40, 0.02, 0.40, 0.05, 0.40, 0.10, 0.40, 
0.35, 0.40, 0.55), nrow=2)
prior_tox = c(0.02, 0.06, 0.12, 0.20, 0.30, 0.40)
prior_eff = c(0.12, 0.20, 0.30, 0.40, 0.50, 0.59)
prior_eff2 = rbind(prior_eff, prior_eff)
s_1=function(n_cur){0.2}
n=60

# With only one group and efficacy as time-to-event
#sim1 = mta_sim(ngroups=1, ndose=6, p_tox= p_tox_sc1, p_eff= p_eff_sc1_g1, 
#       tox_max=0.35, eff_min=0.20, prior_tox=prior_tox, prior_eff= prior_eff, 
#       poisson_rate=0.28, n=60, cohort_start=3, cohort=3, tite=TRUE, 
#       time_full=7, cycle=3, nsim=1)
#sim1

# With only one group and efficacy binary
#sim2 = mta_sim(ngroups=1, ndose=6, p_tox= p_tox_sc1, p_eff= p_eff_sc1_g1, 
#       tox_max=0.35, eff_min=0.20, prior_tox=prior_tox, prior_eff= prior_eff, 
#       n=n, cohort_start=3, cohort=3, tite=FALSE, method="MTA-RA", 
#       s_1=function(n_cur){0.2*(1-n_cur/n)}, nsim=1)
#sim2

# With only two groups and efficacy as time-to-event
#sim3 = mta_sim(ngroups=2, ndose=6, p_tox= p_tox_sc2, p_eff= p_eff_sc2_g2, 
#               tox_max=0.35, eff_min=0.20, prior_tox=prior_tox, 
#               prior_eff= prior_eff2, poisson_rate=c(0.40,0.25) , n=60, 
#               cohort_start=3, cohort=3, tite=TRUE, time_full=7, 
#               method="MTA-PM", s_2=0.07, cycle=3, nsim=1, c_tox=0.90, 
#               c_eff=0.40)
#sim3
}
