\name{VarWT}
\alias{VarWT}

\title{
The variance weighted (VarWT) pooling approach. 
}

\description{
An alternative method to combine toxicities across the trials. Accordingly, we estimate the pooled toxicity probability at dose level x using the \deqn{R_c(x) = \sum_{i=1}^{R} \frac{\sigma_{i}^2 (x)}{\sigma^{2}(x)} \bar{R_i}(x),} where \deqn{\sigma_{i}^2(x) = N_i(x)\bar{R_i}(x)(1-\bar{R_i}(x))} and \deqn{\sigma^{2}(x) = \sum_{i=1}^{R} \sigma_i^2 (x), x \in D.}
Then, to find the pooled estimates of MTD you can use either (a) the non-parametric pooled MTD estimator can be definied by the dose \eqn{x_0 \in D} such that:
\deqn{|R_c(\hat{x_0}) - \theta| <= |R_c(x) - \theta|,  x \neq \hat{x_0}}
OR (b) the model-based algorithm.
}

\usage{
VarWT(dataTox, saveName)
}

\arguments{
  \item{dataTox}{
a data frame containing information for each patient at each simulation and trial.
}
  \item{saveName}{
the name of the .txt output which will be created and saved in the current working directory; must be in characters; defaults to NULL. If saveName = NULL, means that nothing will be saved in the working directory.
}
}

\value{ 
A list is returned, combining the toxicities across the trials. The output, generated by the function VarWT, contains the following components:
  \item{dataTox}{
  A data frame containing the estimated pooled toxicity probabilities at each dose level for each simulation.
  }
If saveName is not equal to "NULL" then a .txt file is saved in the working directory storing the estimated pooled toxicity probabilities at each dose level for each simulation.
}

\author{
Artemis Toumazi <artemis.toumazi@gmail.com>, Sarah Zohar <sarah.zohar@inserm.fr>, Anand N. Vidyashankar <avidyash@gmu.edu>, Jie Xu <jxu13@gmu.edu> and Moreno Ursino <moreno.ursino@inserm.fr>
}

\seealso{
\code{\link{ZKO}}
}

\examples{
  \dontrun{
    ## Using the toxicity dataset for each simulation and each trial, which is 
    ## existing in the dfmeta package.
    
    data("Toxdata")
    dim(Toxdata)
    colnames(Toxdata)
    
    ## NOTE: The toxicity dataset must have the same structure as below. ##
    ## Check it before running the VarWT function! ##
    
    str(Toxdata)

    #################################
    ## Running the VarWT function! ##
    #################################
    
    WT <- VarWT(Toxdata)
    
    ######### If we want to save the result in a text file ###########
    ####### we need to give a name in the argument "saveName" ########
    
    WT <- VarWT(Toxdata, tempdir())
  }
}

