% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toggle_message.R
\name{toggle_message}
\alias{toggle_message}
\title{Controllable console messages}
\usage{
toggle_message(..., verbose)
}
\arguments{
\item{...}{any message you would normally pass into \code{message()}. See
\code{\link{message}} for more details}

\item{verbose}{logical, usually a variable passed from the function you are
using this within}
}
\value{
No return value, called for side effects
}
\description{
Quick expansion to the \code{message()} function aimed for use in functions for
an easy addition of a global verbose TRUE / FALSE argument to toggle the
messages on or off
}
\examples{
# Usually used in a function
my_function <- function(count_fingers, verbose) {
  toggle_message("I have ", count_fingers, " fingers", verbose = verbose)
  fingers_thumbs <- count_fingers + 2
  toggle_message("I have ", fingers_thumbs, " digits", verbose = verbose)
}

my_function(5, verbose = FALSE)
my_function(5, verbose = TRUE)

# Can be used in isolation
toggle_message("I want the world to read this!", verbose = TRUE)
toggle_message("I ain't gonna show this message!", verbose = FALSE)

count_fingers <- 5
toggle_message("I have ", count_fingers, " fingers", verbose = TRUE)
}
