% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist-f.R
\name{dist_f_plot}
\alias{dist_f_plot}
\alias{dist_f_perc}
\alias{dist_f_prob}
\title{Visualize f distribution}
\usage{
dist_f_plot(num_df = 4, den_df = 30, normal = FALSE)

dist_f_perc(probs = 0.95, num_df = 3, den_df = 30,
  type = c("lower", "upper"))

dist_f_prob(perc, num_df, den_df, type = c("lower", "upper"))
}
\arguments{
\item{num_df}{Degrees of freedom associated with the numerator of f statistic.}

\item{den_df}{Degrees of freedom associated with the denominator of f statistic.}

\item{normal}{If \code{TRUE}, normal curve with same \code{mean} and
\code{sd} as the F distribution is drawn.}

\item{probs}{Probability value.}

\item{type}{Lower tail or upper tail.}

\item{perc}{Quantile value.}
}
\value{
Percentile for the \code{probs} based on \code{num_df}, \code{den_df}
and \code{type} or probability value for \code{perc} based on \code{num_df},
\code{den_df} and \code{type}.
}
\description{
Visualize how changes in degrees of freedom affect the
shape of the F distribution. Compute & visualize quantiles out of given
probability and probability from a given quantile.
}
\examples{
# visualize F distribution
dist_f_plot()
dist_f_plot(6, 10, normal = TRUE)

# visualize probability from a given quantile
dist_f_perc(0.95, 3, 30, 'lower')
dist_f_perc(0.125, 9, 35, 'upper')

# visualize quantiles out of given probability
dist_f_prob(2.35, 5, 32)
dist_f_prob(1.5222, 9, 35, type = "upper")

}
\seealso{
\code{\link[stats]{FDist}}
}
