% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariate_compare.R
\name{bivariate_compare}
\alias{bivariate_compare}
\title{Create publication-style table across one categorical variable}
\usage{
bivariate_compare(df, compare, normal_vars = NULL,
  non_normal_vars = NULL, cat_vars = NULL, display_round = 2,
  p = TRUE, p_round = 4, include_na = FALSE, col_n = TRUE,
  cont_n = FALSE, all_cont_mean = FALSE, all_cont_median = FALSE,
  iqr = TRUE, fisher = FALSE, workspace = NULL, var_order = NULL,
  var_label_df = NULL)
}
\arguments{
\item{df}{A data.frame or tibble.}

\item{compare}{Discrete variable. Separate statistics will be produced for
each level, with statistical tests across levels. Must be quoted.}

\item{normal_vars}{Character vector of normally distributed continuous
variables that will be included in the descriptive table.}

\item{non_normal_vars}{Character vector of non-normally distributed continuous
variables that will be included in the descriptive table.}

\item{cat_vars}{Character vector of categorical variables that will be
included in the descriptive table.}

\item{display_round}{Number of decimal places displayed values should be 
rounded to}

\item{p}{Logical. Should p-values be calculated and displayed?
Default \code{TRUE}.}

\item{p_round}{Number of decimal places p-values should be rounded to.}

\item{include_na}{Logical. Should \code{NA} values be included in the
table and accompanying statistical tests? Default \code{FALSE}.}

\item{col_n}{Logical. Should the total number of observations be displayed
for each column? Default \code{TRUE}.}

\item{cont_n}{Logical. Display sample n for continuous variables in the
table. Default \code{FALSE}.}

\item{all_cont_mean}{Logical. Display mean (sd) for all continuous variables.
Default \code{FALSE} results in mean (sd) for normally distributed variables
and median (IQR) for non-normally distributed variables. Must be
\code{FALSE} if \code{all_cont_median == TRUE}.}

\item{all_cont_median}{Logical. Display median (sd) for all continuous variables.
Default \code{FALSE} results in mean (sd) for normally distributed variables
and median (IQR) for non-normally distributed variables. Must be
\code{FALSE} if \code{all_cont_mean == TRUE}.}

\item{iqr}{Logical. If the median is displayed for a continuous variable, should
interquartile range be displayed as well (\code{TRUE}), or should the values
for the 25th and 75th percentiles be displayed (\code{FALSE})? Default
\code{TRUE}}

\item{fisher}{Logical. Should Fisher's exact test be used for categorical
variables? Default \code{FALSE}. Ignored if \code{p == FALSE}.}

\item{workspace}{Numeric variable indicating the workspace to be used for
Fisher's exact test. If \code{NULL}, the default, the default value of
\code{2e5} is used. Ignored if \code{fisher == FALSE}.}

\item{var_order}{Character vector listing the variable names in the order
results should be displayed. If \code{NULL}, the default, continuous
variables are displayed first, followed by categorical variables.}

\item{var_label_df}{A data.frame or tibble with columns "variable" and
"label" that contains display labels for each variable specified in
\code{normal_vars}, \code{non_normal_vars}, and \code{cat_vars}.}
}
\value{
A data.frame with columns label, overall, a column for each level
  of \code{compare}, and p.value. For \code{normal_vars}, mean (SD) is
  displayed, for \code{non_normal_vars} median (IQR) is displayed, and for
  \code{cat_vars} n (percent) is displayed. For p values on continuous
  variables, a superscript 'a' denotes the Kruskal-Wallis test was used
}
\description{
Descriptive statistics for categorical variables as well as normally and
non-normally distributed continuous variables, split across levels of
a categorical variable. Depending on the variable type, an appropriate
statistical test is used to assess differences across levels of the
comparison variable.
}
\details{
Statistical differences between normally distributed continuous variables
are assessed using \code{aov()}, differences in non-normally distributed
variables are assessed using \code{kruskal.test()}, and differences in
categorical variables are assessed using \code{chisq.test()} by default,
with a user option for \code{fisher.test()} instead.
}
\examples{
bivariate_compare(iris, compare = "Species", normal_vars = c("Sepal.Length", "Sepal.Width"))

bivariate_compare(mtcars, compare = "cyl", non_normal_vars = "mpg")
}
