% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.summary.kliep}
\alias{print.summary.kliep}
\title{Print a \code{summary.kliep} object}
\usage{
\method{print}{summary.kliep}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{Object of class \code{summary.kliep}.}

\item{digits}{Number of digits to use when printing the output.}

\item{...}{further arguments on how to format the number of digits.}
}
\value{
\code{invisble} The inputted \code{summary.kliep} object.
}
\description{
Print a \code{summary.kliep} object
}
\examples{
set.seed(123)
# Fit model
dr <- kliep(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
kliep(numerator_small, denominator_small,
      nsigma = 1, ncenters = 100, nfold = 10,
      epsilon = 10^{2:-5}, maxit = 500)
}
\seealso{
\code{\link{print}}, \code{\link{summary.kliep}}, \code{\link{kliep}}
}
