% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase_plot.R
\name{phase_plot}
\alias{phase_plot}
\title{Plot stem-cyclic phases}
\usage{
phase_plot(dm.gpf, dm.phase, sensor = NULL, period = NULL, colPhases = NULL, ...)
}
\arguments{
\item{dm.gpf}{a \code{data.frame} with gap-filled dendrometer series as produced by \code{\link{fill_gaps}}.}

\item{dm.phase}{a \code{data.frame} with numbers indicating the different stem-cyclic phases. Output of \code{\link{phase_def}}.}

\item{sensor}{a \code{numeric} specifying the sensor to be plotted (by column number). Alternatively, \code{sensor} can be a \code{character} with column names. Concatenations and sequences are allowed for plotting phase definitions of multiple sensors at once. Defaults to all sensors in \code{dm.gpf} and \code{dm.phase}.}

\item{period}{a \code{numeric} indicating the period to be plotted, specified using day of year values (begin and end). Defaults to the complete data period. Alternatively, \code{period} can be a \code{character} of two time stamps, indicating the begin and end date of the period to be plotted.}

\item{colPhases}{a \code{vector} of length 3, specifying custom colors to be used for the three stem-cyclic phases. Defaults to the first three colors from the current \code{\link{palette}}.}

\item{...}{additional graphical parameters (see \code{\link{par}}).}
}
\value{
Plot showing stem-cyclic phases on dendrometer series.
}
\description{
The function creates a plot showing the three distinct phases of contraction, expansion and stem-radius increment (Deslauriers et al. 2011) for dendrometer series from a \code{data.frame} as produced by \code{\link{phase_def}}.
}
\details{
The function plots phases of contraction, expansion and stem-radius increment along (one or more) dendrometer series. If more series are plotted (default), colors for the different lines can be defined using the \code{col} argument for graphical devices (see \code{\link{par}}). Note: if there are not enough custom colors, the function will repeat the last one used. If no colors are defined, the current \code{\link{palette}} will be used.

The time axis will be automatically labeled depending upon the length of the dendrometer series. If \code{period} is specified using a \code{numeric}, DOY values are displayed on the x-axis. In case a \code{character} of two time stamps is provided, axis labeling will be as follows: if series are longer than 120 days, years and months will be shown. If the length is between 30 and 120 days, months and days, and below 30 days, months, days and hours are displayed.
}
\examples{
data(dmCD)
dm.phase <- phase_def(dmCD)
phase_plot(dmCD, dm.phase)

# zoom in on the dendrometer series
phase_plot(dmCD, dm.phase, period = c(133, 142))

# customization options
phase_plot(dmCD, dm.phase, period = c("2008-05-12", "2008-05-22"),
           colPhases = c("green", "cyan", "orange"),
           pch = 4, main = "Dendrometer", ylab = "Values")

# specific sensors may be selected as follows:

\donttest{
data(dmED)
dm.gpf <- fill_gaps(dmED)
dm.phase <- phase_def(dm.gpf)
phase_plot(dm.gpf, dm.phase, sensor = 1)
phase_plot(dm.gpf, dm.phase, sensor = c(2,1))
phase_plot(dm.gpf, dm.phase, sensor = "Beech03")
phase_plot(dm.gpf, dm.phase, sensor = c("Beech03", "Beech04"))
}

}
\references{
Deslauriers, A., Rossi, S., Turcotte, A., Morin, H. and Krause, C. (2011) A three-step procedure in SAS to analyze the time series from automatic dendrometers. \emph{Dendrochronologia} 29: 151-161.
}
\author{
Marko Smiljanic
}
