% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nodes_xy.R
\name{get_nodes_xy}
\alias{get_nodes_xy}
\title{Get the x-y coordinates of a dendrogram's nodes}
\source{
This is a striped down version of the 
function \code{\link{plot.dendrogram}}.
It performs (almost) the same task, only it does not do any plotting
but it does save the x-y coordiantes of the nodes.
}
\usage{
get_nodes_xy(dend, type = c("rectangle", "triangle"), center = FALSE,
  horiz = FALSE, ...)
}
\arguments{
\item{dend}{a dendrogram object}

\item{type}{type of plot.}

\item{center}{logical; if TRUE, nodes are plotted centered with respect to the 
leaves in the branch. Otherwise (default), 
plot them in the middle of all direct child nodes.}

\item{horiz}{logical indicating if the dendrogram should be drawn horizontally or not.}

\item{...}{not used}
}
\value{
A 2-dimensional matrix, with rows as the number of nodes,
and the first column is the x location, while the second is the
y location.
}
\description{
Get the x-y coordinates of a dendrogram's nodes. Can be used to add text or images on the tree.
}
\examples{
\dontrun{

# If we would like to see the numbers from plot:
# ?getOption("verbose")
# options(verbose=TRUE)
# options(verbose=FALSE)

# -----
# Draw a depth first search illustration
# -----

dend <- 1:5 \%>\% dist \%>\% hclust \%>\% as.dendrogram
get_nodes_xy(dend)

# polygon(get_nodes_xy(dend), col = 2)
plot(dend, 
     leaflab = "none",
     main = "Depth-first search in a dendrogram")
xy <- get_nodes_xy(dend)
for(i in 1:(nrow(xy)-1)) {
   arrows(xy[i,1], xy[i,2], angle = 17,
          length = .5,
          xy[i+1,1], xy[i+1,2], 
          lty = 1, col = 3, lwd = 1.5)   
}
points(xy, pch = 19, cex = 4)
text(xy, labels = 1:nnodes(dend),cex = 1.2, col = "white", adj = c(0.4,0.4))

}
}
\seealso{
\link{get_nodes_attr}, \link{nnodes},
\link{nleaves}
}
