% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_subdendrograms.R
\name{collapse_labels}
\alias{collapse_labels}
\title{Collapse a sub dendrogram of adjacent labels within a dend}
\usage{
collapse_labels(dend, selected_labels, ...)
}
\arguments{
\item{dend}{a dendrogram object}

\item{selected_labels}{A character vector with the labels we expect to have 
in the sub-dendrogram. This doesn't have to be in the same order as in the dendrogram.}

\item{...}{elipsis (passed to squash_dendrogram)}
}
\value{
Either the original dend.
Or, if the labels properly are in the dend by each other, a dend with
a squashed sub-dendrogram inside it.
}
\description{
Given a dendrogram object, and a set of labels that are in the same sub-dendrogram,
the function performs a recursive DFS algorithm to determine
the sub-dendrogram which is composed of (exactly) all 'selected_labels'.
It then squashes this sub-dendrogram, and returns the original dendrogram with the squashed 
dendrogram with it.
}
\examples{
library("dendextend")

set.seed(23235)
ss <- sample(1:150, 5)

# Getting the dend object
dend25 <- iris[ss, -5] \%>\%
   dist() \%>\%
   hclust() \%>\%
   as.dendrogram() \%>\% 
   set("labels", letters[1:5])

par(mfrow = c(1,4))
plot(dend25)
plot(collapse_labels(dend25, c("d", "e")))
plot(collapse_labels(dend25, c("c", "d", "e")))
plot(collapse_labels(dend25, c("c", "d", "e"), squashed_original_height=TRUE))
}
